/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.remote;

import java.time.Duration;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.infinispan.client.hotrod.RemoteCache;
import org.wildfly.clustering.cache.infinispan.AbstractCacheEntryMutator;

public class RemoteCacheEntryComputer<K, V>
extends AbstractCacheEntryMutator {
    private final RemoteCache<K, V> cache;
    private final K key;
    private final BiFunction<Object, V, V> function;

    RemoteCacheEntryComputer(RemoteCache<K, V> cache, K key, BiFunction<Object, V, V> function) {
        this.cache = cache;
        this.key = key;
        this.function = function;
    }

    public CompletionStage<Void> runAsync() {
        Duration maxIdleDuration = this.get();
        long seconds = maxIdleDuration.getSeconds();
        int nanos = maxIdleDuration.getNano();
        if (nanos > 0) {
            ++seconds;
        }
        return this.cache.computeAsync(this.key, this.function, 0L, TimeUnit.SECONDS, seconds, TimeUnit.SECONDS).thenAccept((Consumer)org.wildfly.clustering.function.Consumer.empty());
    }
}

