/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.injection.finders;

import jakarta.annotation.Resource;
import java.lang.reflect.Method;
import org.jboss.ws.common.injection.finders.ReflectionUtils;
import org.jboss.ws.common.reflection.AnnotatedMethodFinder;

public final class ResourceMethodFinder
extends AnnotatedMethodFinder<Resource> {
    private final Class<?> accept;
    private final boolean include;

    public ResourceMethodFinder(Class<?> accept, boolean include) {
        super(Resource.class);
        this.accept = accept;
        this.include = include;
    }

    @Override
    public void validate(Method method) {
        super.validate(method);
        Class annotation = this.getAnnotation();
        ReflectionUtils.assertVoidReturnType(method, annotation);
        ReflectionUtils.assertOneParameter(method, annotation);
        ReflectionUtils.assertNoPrimitiveParameters(method, annotation);
        ReflectionUtils.assertValidSetterName(method, annotation);
        ReflectionUtils.assertNoCheckedExceptionsAreThrown(method, annotation);
        ReflectionUtils.assertNotStatic(method, annotation);
    }

    @Override
    public boolean matches(Method method) {
        boolean matches = super.matches(method);
        if (matches && this.accept != null && method.getParameterTypes().length == 1) {
            Class<?> param = method.getParameterTypes()[0];
            boolean parameterMatch = this.accept.equals(param);
            return this.include ? parameterMatch : !parameterMatch;
        }
        return matches;
    }
}

