/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.search.mapper.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingBuildContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingConfigurationCollector;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingConfigurationContext;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingConfigurationContributor;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.infinispan.search.mapper.impl.InfinispanEntityTypeContributor;
import org.infinispan.search.mapper.log.impl.Log;
import org.infinispan.util.logging.LogFactory;

class InfinispanTypeConfigurationContributor
implements PojoMappingConfigurationContributor {
    private static final Log log = (Log)LogFactory.getLog(InfinispanTypeConfigurationContributor.class, Log.class);
    private final PojoBootstrapIntrospector introspector;
    private final Map<String, Class<?>> entityTypeByName = new LinkedHashMap();

    public InfinispanTypeConfigurationContributor(PojoBootstrapIntrospector introspector) {
        this.introspector = introspector;
    }

    public void configure(MappingBuildContext buildContext, PojoMappingConfigurationContext configurationContext, MappingConfigurationCollector<PojoTypeMetadataContributor> configurationCollector) {
        for (Map.Entry<String, Class<?>> entry : this.entityTypeByName.entrySet()) {
            PojoRawTypeModel typeModel = this.identifiedByName(entry.getValue()) ? this.introspector.typeModel(entry.getKey()) : this.introspector.typeModel(entry.getValue());
            configurationCollector.collectContributor((MappableTypeModel)typeModel, (Object)new InfinispanEntityTypeContributor(typeModel.typeIdentifier(), entry.getKey()));
        }
    }

    void addEntityType(Class<?> type, String entityName) {
        Class<?> previousType = this.entityTypeByName.putIfAbsent(entityName, type);
        if (previousType != null && previousType != type) {
            throw log.multipleEntityTypesWithSameName(entityName, previousType, type);
        }
    }

    private boolean identifiedByName(Class<?> type) {
        return byte[].class == type;
    }
}

