/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web.session.infinispan;

import jakarta.servlet.ServletContext;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ExpirationConfiguration;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.eviction.EvictionStrategy;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.wildfly.clustering.cache.infinispan.embedded.container.DataContainerConfigurationBuilder;
import org.wildfly.clustering.infinispan.service.CacheConfigurationServiceInstaller;
import org.wildfly.clustering.infinispan.service.CacheServiceInstaller;
import org.wildfly.clustering.infinispan.service.InfinispanServiceDescriptor;
import org.wildfly.clustering.server.infinispan.dispatcher.CacheContainerCommandDispatcherFactory;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.clustering.server.service.ClusteringServiceDescriptor;
import org.wildfly.clustering.session.SessionManagerFactory;
import org.wildfly.clustering.session.infinispan.embedded.InfinispanSessionManagerFactory;
import org.wildfly.clustering.session.infinispan.embedded.InfinispanSessionManagerFactoryConfiguration;
import org.wildfly.clustering.session.infinispan.embedded.metadata.SessionMetaDataKey;
import org.wildfly.clustering.session.spec.SessionEventListenerSpecificationProvider;
import org.wildfly.clustering.session.spec.SessionSpecificationProvider;
import org.wildfly.clustering.session.spec.servlet.HttpSessionActivationListenerProvider;
import org.wildfly.clustering.session.spec.servlet.HttpSessionProvider;
import org.wildfly.clustering.web.service.deployment.WebDeploymentServiceDescriptor;
import org.wildfly.clustering.web.service.routing.RouteLocatorProvider;
import org.wildfly.clustering.web.service.session.DistributableSessionManagementConfiguration;
import org.wildfly.clustering.web.service.session.SessionManagerFactoryConfiguration;
import org.wildfly.common.function.Functions;
import org.wildfly.extension.clustering.web.session.AbstractSessionManagementProvider;
import org.wildfly.subsystem.service.DeploymentServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class InfinispanSessionManagementProvider
extends AbstractSessionManagementProvider {
    public InfinispanSessionManagementProvider(DistributableSessionManagementConfiguration<DeploymentUnit> configuration, BinaryServiceConfiguration cacheConfiguration, RouteLocatorProvider locatorProvider) {
        super(configuration, cacheConfiguration, locatorProvider);
    }

    public <C> DeploymentServiceInstaller getSessionManagerFactoryServiceInstaller(final SessionManagerFactoryConfiguration<C> configuration) {
        BinaryServiceConfiguration templateCacheConfiguration = this.getCacheConfiguration();
        BinaryServiceConfiguration deploymentCacheConfiguration = templateCacheConfiguration.withChildName(configuration.getDeploymentName());
        UnaryOperator<ConfigurationBuilder> configurator = new UnaryOperator<ConfigurationBuilder>(){

            @Override
            public ConfigurationBuilder apply(ConfigurationBuilder builder) {
                OptionalInt size;
                ExpirationConfiguration expiration = builder.expiration().create();
                if (expiration.lifespan() >= 0L || expiration.maxIdle() >= 0L) {
                    builder.expiration().lifespan(-1L).maxIdle(-1L);
                }
                EvictionStrategy strategy = (size = configuration.getMaxActiveSessions()).isPresent() ? EvictionStrategy.REMOVE : EvictionStrategy.NONE;
                builder.memory().storage(StorageType.HEAP).whenFull(strategy).maxCount((long)size.orElse(0));
                if (strategy.isEnabled()) {
                    ((DataContainerConfigurationBuilder)builder.addModule(DataContainerConfigurationBuilder.class)).evictable(SessionMetaDataKey.class::isInstance);
                }
                PersistenceConfiguration persistence = builder.persistence().create();
                if (size.isEmpty() && persistence.passivation() && persistence.stores().stream().allMatch(StoreConfiguration::purgeOnStartup)) {
                    builder.persistence().passivation(false).clearStores();
                }
                return builder;
            }
        };
        CacheConfigurationServiceInstaller configurationInstaller = new CacheConfigurationServiceInstaller(deploymentCacheConfiguration, CacheConfigurationServiceInstaller.fromTemplate((BinaryServiceConfiguration)templateCacheConfiguration).map((Function)configurator));
        CacheServiceInstaller cacheInstaller = new CacheServiceInstaller(deploymentCacheConfiguration);
        final ServiceDependency commandDispatcherFactory = deploymentCacheConfiguration.getServiceDependency(ClusteringServiceDescriptor.COMMAND_DISPATCHER_FACTORY).map(CacheContainerCommandDispatcherFactory.class::cast);
        final ServiceDependency cache = deploymentCacheConfiguration.getServiceDependency(InfinispanServiceDescriptor.CACHE);
        final InfinispanSessionManagerFactoryConfiguration factoryConfiguration = new InfinispanSessionManagerFactoryConfiguration(){

            public <K, V> Cache<K, V> getCache() {
                return (Cache)cache.get();
            }

            public CacheContainerCommandDispatcherFactory getCommandDispatcherFactory() {
                return (CacheContainerCommandDispatcherFactory)commandDispatcherFactory.get();
            }
        };
        Supplier factory = new Supplier<SessionManagerFactory<ServletContext, C>>(){

            @Override
            public SessionManagerFactory<ServletContext, C> get() {
                return new InfinispanSessionManagerFactory((org.wildfly.clustering.session.SessionManagerFactoryConfiguration)configuration, (SessionSpecificationProvider)HttpSessionProvider.INSTANCE, (SessionEventListenerSpecificationProvider)HttpSessionActivationListenerProvider.INSTANCE, factoryConfiguration);
            }
        };
        DeploymentServiceInstaller installer = (DeploymentServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((Supplier)factory).provides(WebDeploymentServiceDescriptor.SESSION_MANAGER_FACTORY.resolve(configuration.getDeploymentUnit()))).requires(List.of(cache, commandDispatcherFactory))).onStop(Functions.closingConsumer())).build();
        return DeploymentServiceInstaller.combine((DeploymentServiceInstaller[])new DeploymentServiceInstaller[]{configurationInstaller, cacheInstaller, installer});
    }
}

