/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.LongRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.subsystem.resource.ResourceModelResolver;

public class DurationAttributeDefinition
extends SimpleAttributeDefinition
implements ResourceModelResolver<Duration> {
    private final ChronoUnit unit;

    DurationAttributeDefinition(Builder builder) {
        super((AbstractAttributeDefinitionBuilder)builder);
        this.unit = builder.unit;
    }

    public Duration resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        Long value = this.resolveModelAttribute(context, model).asLongOrNull();
        return value != null ? Duration.of(value, this.unit) : null;
    }

    static MeasurementUnit toMeasurementUnit(ChronoUnit unit) {
        switch (unit) {
            case NANOS: {
                return MeasurementUnit.NANOSECONDS;
            }
            case MICROS: {
                return MeasurementUnit.MICROSECONDS;
            }
            case MILLIS: {
                return MeasurementUnit.MILLISECONDS;
            }
            case SECONDS: {
                return MeasurementUnit.SECONDS;
            }
            case MINUTES: {
                return MeasurementUnit.MINUTES;
            }
            case HOURS: {
                return MeasurementUnit.HOURS;
            }
            case DAYS: {
                return MeasurementUnit.DAYS;
            }
        }
        throw new IllegalArgumentException(unit.name());
    }

    public static class Builder
    extends AbstractAttributeDefinitionBuilder<Builder, DurationAttributeDefinition> {
        private final ChronoUnit unit;

        public Builder(String attributeName, ChronoUnit unit) {
            super(attributeName, ModelType.LONG);
            this.unit = unit;
            this.setAllowExpression(true);
            this.setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES});
            this.setMeasurementUnit(DurationAttributeDefinition.toMeasurementUnit(unit));
            this.setValidator((ParameterValidator)new LongRangeValidator(0L));
        }

        public Builder(String attributeName, DurationAttributeDefinition basis) {
            super(attributeName, (AttributeDefinition)basis);
            this.unit = basis.unit;
        }

        public Builder setDefaultValue(Duration duration) {
            if (duration != null) {
                this.setRequired(false);
                this.setDefaultValue(duration.isZero() ? ModelNode.ZERO_LONG : new ModelNode(this.unit.between(Instant.EPOCH, Instant.EPOCH.plus(duration))));
            }
            return this;
        }

        public DurationAttributeDefinition build() {
            return new DurationAttributeDefinition(this);
        }
    }
}

