/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import jakarta.json.bind.JsonbException;
import jakarta.json.stream.JsonGenerator;
import java.lang.invoke.MethodHandle;
import org.eclipse.yasson.internal.SerializationContextImpl;
import org.eclipse.yasson.internal.serializer.ModelSerializer;

class ValueGetterSerializer
implements ModelSerializer {
    private final MethodHandle valueGetter;
    private final ModelSerializer delegate;

    ValueGetterSerializer(MethodHandle valueGetter, ModelSerializer delegate) {
        this.valueGetter = valueGetter;
        this.delegate = delegate;
    }

    @Override
    public void serialize(Object value, JsonGenerator generator, SerializationContextImpl context) {
        Object object;
        try {
            object = this.valueGetter.invoke(value);
        }
        catch (Throwable e) {
            throw new JsonbException("Error getting value on: " + value.getClass().getName(), e);
        }
        this.delegate.serialize(object, generator, context);
    }
}

