/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.io.Externalizable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.deployers.AbstractComponentConfigProcessor;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;

public class ImplicitLocalViewProcessor
extends AbstractComponentConfigProcessor {
    protected void processComponentConfig(DeploymentUnit deploymentUnit, DeploymentPhaseContext phaseContext, CompositeIndex index, ComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        if (!(componentDescription instanceof SessionBeanComponentDescription)) {
            return;
        }
        SessionBeanComponentDescription sessionBeanComponentDescription = (SessionBeanComponentDescription)componentDescription;
        if (sessionBeanComponentDescription.hasNoInterfaceView()) {
            return;
        }
        if (!sessionBeanComponentDescription.getViews().isEmpty()) {
            return;
        }
        String ejbClassName = sessionBeanComponentDescription.getComponentClassName();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        if (module == null) {
            throw EjbLogger.ROOT_LOGGER.moduleNotAttachedToDeploymentUnit(deploymentUnit);
        }
        ModuleClassLoader cl = module.getClassLoader();
        Class<?> ejbClass = null;
        try {
            ejbClass = cl.loadClass(ejbClassName);
        }
        catch (ClassNotFoundException cnfe) {
            throw new DeploymentUnitProcessingException((Throwable)cnfe);
        }
        if (this.exposesNoInterfaceView(ejbClass)) {
            EjbLogger.DEPLOYMENT_LOGGER.debugf("Bean: %s will be marked for (implicit) no-interface view", sessionBeanComponentDescription.getEJBName());
            sessionBeanComponentDescription.addNoInterfaceView();
            return;
        }
        Class<?> defaultLocalView = this.getDefaultLocalView(ejbClass);
        if (defaultLocalView != null) {
            EjbLogger.DEPLOYMENT_LOGGER.debugf("Bean: %s will be marked for default local view: %s", sessionBeanComponentDescription.getEJBName(), defaultLocalView.getName());
            sessionBeanComponentDescription.addLocalBusinessInterfaceViews(Collections.singleton(defaultLocalView.getName()));
            return;
        }
    }

    private boolean exposesNoInterfaceView(Class<?> beanClass) {
        Class<?>[] interfaces = beanClass.getInterfaces();
        if (interfaces.length == 0) {
            return true;
        }
        ArrayList implementedInterfaces = new ArrayList(Arrays.asList(interfaces));
        List<Class<?>> filteredInterfaces = this.filterInterfaces(implementedInterfaces);
        return filteredInterfaces.isEmpty();
    }

    private Class<?> getDefaultLocalView(Class<?> beanClass) {
        Class<?>[] interfaces = beanClass.getInterfaces();
        if (interfaces.length == 0) {
            return null;
        }
        ArrayList implementedInterfaces = new ArrayList(Arrays.asList(interfaces));
        List<Class<?>> filteredInterfaces = this.filterInterfaces(implementedInterfaces);
        if (filteredInterfaces.isEmpty() || filteredInterfaces.size() > 1) {
            return null;
        }
        return filteredInterfaces.get(0);
    }

    private List<Class<?>> filterInterfaces(List<Class<?>> interfaces) {
        if (interfaces == null) {
            return null;
        }
        ArrayList filteredInterfaces = new ArrayList();
        for (Class<?> intf : interfaces) {
            if (intf.equals(Serializable.class) || intf.equals(Externalizable.class) || intf.getName().startsWith("jakarta.ejb.")) continue;
            filteredInterfaces.add(intf);
        }
        return filteredInterfaces;
    }
}

