/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.opentelemetry.implementation.exporters;

import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.internal.grpc.GrpcExporter;
import io.opentelemetry.exporter.internal.http.HttpExporter;
import io.opentelemetry.exporter.internal.http.HttpSender;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.smallrye.common.annotation.Identifier;
import io.smallrye.opentelemetry.implementation.exporters.HttpClientOptionsConsumer;
import io.smallrye.opentelemetry.implementation.exporters.OtlpExporterUtil;
import io.smallrye.opentelemetry.implementation.exporters.sender.VertxGrpcSender;
import io.smallrye.opentelemetry.implementation.exporters.sender.VertxHttpSender;
import io.vertx.core.Vertx;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractVertxExporterProvider<T extends Marshaler> {
    private final String signalType;
    private final String exporterName;
    private static final Logger logger = Logger.getLogger(AbstractVertxExporterProvider.class.getName());

    public AbstractVertxExporterProvider(String signalType, String exporterName) {
        this.signalType = signalType;
        this.exporterName = exporterName;
    }

    public String getName() {
        return this.exporterName;
    }

    protected String getSignalType() {
        return this.signalType;
    }

    protected GrpcExporter<T> createGrpcExporter(ConfigProperties config, String grpcEndpointPath) throws URISyntaxException {
        return new GrpcExporter(this.getName(), this.getSignalType(), this.createGrpcSender(config, grpcEndpointPath), MeterProvider::noop);
    }

    protected HttpExporter<T> createHttpExporter(ConfigProperties config, String httpEndpointPath) throws URISyntaxException {
        return new HttpExporter(this.getName(), this.getSignalType(), (HttpSender)this.createHttpSender(config, httpEndpointPath), MeterProvider::noop, false);
    }

    private Vertx getVertx(ConfigProperties config) {
        String cdiQualifier = config.getString("otel.exporter.vertx.cdi.identifier");
        if (cdiQualifier != null && !cdiQualifier.isEmpty()) {
            Instance vertxCDI = CDI.current().select(Vertx.class, new Annotation[]{Identifier.Literal.of((String)cdiQualifier)});
            if (vertxCDI != null && vertxCDI.isResolvable()) {
                return (Vertx)vertxCDI.get();
            }
            logger.log(Level.WARNING, "The Vertx instance with CDI qualifier @Identifier(\"{0}\") is not resolvable.", cdiQualifier);
        }
        logger.log(Level.INFO, "Create a new Vertx instance");
        return Vertx.vertx();
    }

    protected VertxGrpcSender<T> createGrpcSender(ConfigProperties config, String grpcEndpointPath) throws URISyntaxException {
        URI baseUri = new URI(OtlpExporterUtil.getOtlpEndpoint(config, "http://localhost:4317", this.signalType));
        return new VertxGrpcSender(this.signalType, baseUri, grpcEndpointPath, OtlpExporterUtil.getCompression(config, this.signalType), OtlpExporterUtil.getTimeout(config, this.signalType), OtlpExporterUtil.populateTracingExportHttpHeaders(), new HttpClientOptionsConsumer(config, baseUri, this.signalType), this.getVertx(config));
    }

    protected VertxHttpSender createHttpSender(ConfigProperties config, String httpEndpointPath) throws URISyntaxException {
        URI baseUri = new URI(OtlpExporterUtil.getOtlpEndpoint(config, "http://localhost:4318", this.signalType));
        return new VertxHttpSender(baseUri, httpEndpointPath, OtlpExporterUtil.getCompression(config, this.signalType), OtlpExporterUtil.getTimeout(config, this.signalType), OtlpExporterUtil.populateTracingExportHttpHeaders(), "application/x-protobuf", new HttpClientOptionsConsumer(config, baseUri, this.signalType), this.getVertx(config));
    }

    protected IllegalArgumentException buildUnsupportedProtocolException(String protocol) {
        String signalProperty = String.format("otel.exporter.otlp.%s.endpoint", this.signalType);
        return new IllegalArgumentException(String.format("Unsupported OTLP protocol %s specified. ", protocol) + String.format("Please check the `%s` and/or '%s' properties", signalProperty, "otel.exporter.otlp.endpoint"));
    }
}

