/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.metadata.fine;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.wildfly.clustering.session.cache.metadata.InvalidatableSessionMetaData;
import org.wildfly.clustering.session.cache.metadata.fine.CompositeImmutableSessionMetaData;
import org.wildfly.clustering.session.cache.metadata.fine.SessionAccessMetaData;
import org.wildfly.clustering.session.cache.metadata.fine.SessionCreationMetaData;

public class CompositeSessionMetaData
extends CompositeImmutableSessionMetaData
implements InvalidatableSessionMetaData {
    private final SessionCreationMetaData creationMetaData;
    private final SessionAccessMetaData accessMetaData;
    private final Runnable mutator;
    private final AtomicBoolean valid = new AtomicBoolean(true);

    public CompositeSessionMetaData(SessionCreationMetaData creationMetaData, SessionAccessMetaData accessMetaData, Runnable mutator) {
        super(creationMetaData, accessMetaData);
        this.creationMetaData = creationMetaData;
        this.accessMetaData = accessMetaData;
        this.mutator = mutator;
    }

    @Override
    public boolean isValid() {
        return this.valid.get();
    }

    @Override
    public boolean invalidate() {
        return this.valid.compareAndSet(true, false);
    }

    public void setLastAccess(Instant startTime, Instant endTime) {
        if (startTime.isAfter(endTime)) {
            throw new IllegalStateException();
        }
        Instant creationTime = this.creationMetaData.getCreationTime();
        Instant normalizedStartTime = startTime.truncatedTo(ChronoUnit.MILLIS);
        Duration lastAccess = Duration.between(startTime, endTime.truncatedTo(ChronoUnit.MILLIS));
        long seconds = lastAccess.getSeconds();
        if (lastAccess.getNano() > 0) {
            ++seconds;
        }
        Duration normalizedLastAccess = seconds > 1L ? Duration.ofSeconds(seconds) : ChronoUnit.SECONDS.getDuration();
        this.accessMetaData.setLastAccessDuration(Duration.between(creationTime, normalizedStartTime), normalizedLastAccess);
    }

    public void setTimeout(Duration duration) {
        this.creationMetaData.setTimeout(duration.isNegative() ? Duration.ZERO : duration);
    }

    @Override
    public void close() {
        this.mutator.run();
    }
}

