/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.codec.impl;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.AbstractElasticsearchVectorFieldCodec;
import org.hibernate.search.engine.backend.types.VectorSimilarity;
import org.hibernate.search.util.common.AssertionFailure;

public class ElasticsearchByteVectorFieldCodec
extends AbstractElasticsearchVectorFieldCodec<byte[]> {
    public ElasticsearchByteVectorFieldCodec(Gson gson, VectorSimilarity similarity, int dimension, Integer m, Integer efConstruction, byte[] indexNullAs) {
        super(gson, similarity, dimension, m, efConstruction, indexNullAs);
    }

    @Override
    protected JsonArray toJsonArray(byte[] value) {
        JsonArray array = new JsonArray(value.length);
        for (byte element : value) {
            array.add((Number)element);
        }
        return array;
    }

    @Override
    protected byte[] fromJsonArray(JsonArray jsonElements) {
        int size = jsonElements.size();
        byte[] result = new byte[size];
        for (int i = 0; i < size; ++i) {
            result[i] = jsonElements.get(i).getAsByte();
        }
        return result;
    }

    @Override
    public Class<?> vectorElementsType() {
        return Byte.TYPE;
    }

    @Override
    public float scoreToSimilarity(float score) {
        switch (this.similarity) {
            case DEFAULT: 
            case L2: {
                return (float)Math.sqrt(1.0f / score - 1.0f);
            }
            case DOT_PRODUCT: {
                return (score - 0.5f) * (float)(this.dimension * 32768);
            }
            case COSINE: {
                return 2.0f * score - 1.0f;
            }
            case MAX_INNER_PRODUCT: {
                if (score < 1.0f) {
                    return -1.0f * (1.0f / score - 1.0f);
                }
                return score - 1.0f;
            }
        }
        throw new AssertionFailure("Unknown similarity function: " + String.valueOf(this.similarity));
    }
}

