/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.gson.spi;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.util.Set;
import java.util.function.Supplier;
import org.hibernate.search.backend.elasticsearch.gson.spi.JsonLogHelper;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.RootTypeMapping;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.settings.impl.IndexSettings;
import org.hibernate.search.util.common.impl.CollectionHelper;

public final class GsonProvider {
    private static final Set<TypeToken<?>> TYPES_CAUSING_GSON_CONCURRENT_INITIALIZATION_BUG = CollectionHelper.asImmutableSet((Object[])new TypeToken[]{TypeToken.get(IndexSettings.class), TypeToken.get(RootTypeMapping.class)});
    private final Gson gson;
    private final Gson gsonNoSerializeNulls;
    private final JsonLogHelper logHelper;

    public static GsonProvider create(Supplier<GsonBuilder> builderBaseSupplier, boolean logPrettyPrinting) {
        return new GsonProvider(builderBaseSupplier, logPrettyPrinting);
    }

    private GsonProvider(Supplier<GsonBuilder> builderBaseSupplier, boolean logPrettyPrinting) {
        this.gson = builderBaseSupplier.get().serializeNulls().create();
        GsonProvider.initializeTypeAdapters(this.gson);
        this.gsonNoSerializeNulls = builderBaseSupplier.get().create();
        GsonProvider.initializeTypeAdapters(this.gsonNoSerializeNulls);
        this.logHelper = JsonLogHelper.create(builderBaseSupplier.get(), logPrettyPrinting);
    }

    public Gson getGson() {
        return this.gson;
    }

    public Gson getGsonNoSerializeNulls() {
        return this.gsonNoSerializeNulls;
    }

    public JsonLogHelper getLogHelper() {
        return this.logHelper;
    }

    private static void initializeTypeAdapters(Gson gson) {
        for (TypeToken<?> typeToken : TYPES_CAUSING_GSON_CONCURRENT_INITIALIZATION_BUG) {
            gson.getAdapter(typeToken);
        }
    }
}

