/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.opentelemetry.api;

import io.smallrye.opentelemetry.api.OpenTelemetryConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;

public final class WildFlyOpenTelemetryConfig
implements OpenTelemetryConfig {
    public static NullaryServiceDescriptor<WildFlyOpenTelemetryConfig> SERVICE_DESCRIPTOR = NullaryServiceDescriptor.of((String)"org.wildfly.extension.opentelemetry.config", WildFlyOpenTelemetryConfig.class);
    public static final String OTEL_BSP_MAX_EXPORT_BATCH_SIZE = "otel.bsp.max.export.batch.size";
    public static final String OTEL_BSP_MAX_QUEUE_SIZE = "otel.bsp.max.queue.size";
    public static final String OTEL_BSP_SCHEDULE_DELAY = "otel.bsp.schedule.delay";
    public static final String OTEL_EXPORTER_OTLP_ENDPOINT = "otel.exporter.otlp.endpoint";
    public static final String OTEL_EXPORTER_OTLP_PROTOCOL = "otel.exporter.otlp.protocol";
    public static final String OTEL_EXPORTER_OTLP_TIMEOUT = "otel.exporter.otlp.timeout";
    public static final String OTEL_LOGS_EXPORTER = "otel.logs.exporter";
    public static final String OTEL_PROPAGATORS = "otel.propagators";
    public static final String OTEL_METRICS_EXPORTER = "otel.metrics.exporter";
    public static final String OTEL_SDK_DISABLED = "otel.sdk.disabled";
    public static final String OTEL_SERVICE_NAME = "otel.service.name";
    public static final String OTEL_TRACES_EXPORTER = "otel.traces.exporter";
    public static final String OTEL_TRACES_SAMPLER = "otel.traces.sampler";
    public static final String OTEL_TRACES_SAMPLER_ARG = "otel.traces.sampler.arg";
    private final Map<String, String> properties;
    private final boolean mpTelemetryInstalled;

    WildFlyOpenTelemetryConfig(Map<String, String> properties, boolean mpTelemetryInstalled) {
        this.properties = Collections.unmodifiableMap(properties);
        this.mpTelemetryInstalled = mpTelemetryInstalled;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public boolean isMpTelemetryInstalled() {
        return this.mpTelemetryInstalled;
    }

    public static class Builder {
        final Map<String, String> properties = new HashMap<String, String>();
        private boolean mpTelemetryInstalled;

        public Builder() {
            this.addValue(WildFlyOpenTelemetryConfig.OTEL_EXPORTER_OTLP_PROTOCOL, "grpc");
            this.addValue(WildFlyOpenTelemetryConfig.OTEL_PROPAGATORS, "tracecontext,baggage");
            this.addValue(WildFlyOpenTelemetryConfig.OTEL_SDK_DISABLED, "false");
        }

        public Builder setServiceName(String serviceName) {
            this.addValue(WildFlyOpenTelemetryConfig.OTEL_SERVICE_NAME, serviceName);
            return this;
        }

        public Builder setExporter(String exporter) {
            if (!exporter.equals("otlp")) {
                throw new IllegalArgumentException("An unexpected exporter type was found: " + exporter);
            }
            this.addValue(WildFlyOpenTelemetryConfig.OTEL_TRACES_EXPORTER, exporter);
            this.addValue(WildFlyOpenTelemetryConfig.OTEL_LOGS_EXPORTER, exporter);
            this.addValue(WildFlyOpenTelemetryConfig.OTEL_METRICS_EXPORTER, exporter);
            return this;
        }

        public Builder setOtlpEndpoint(String endpoint) {
            this.addValue(WildFlyOpenTelemetryConfig.OTEL_EXPORTER_OTLP_ENDPOINT, endpoint);
            return this;
        }

        public Builder setExportTimeout(long timeout) {
            this.addValue(WildFlyOpenTelemetryConfig.OTEL_EXPORTER_OTLP_TIMEOUT, timeout);
            return this;
        }

        public Builder setExportInterval(Long interval) {
            this.addValue("otel.metric.export.interval", interval);
            return this;
        }

        public Builder setBatchDelay(long delay) {
            this.addValue(WildFlyOpenTelemetryConfig.OTEL_BSP_SCHEDULE_DELAY, delay);
            return this;
        }

        public Builder setMaxQueueSize(long maxQueueSize) {
            this.addValue(WildFlyOpenTelemetryConfig.OTEL_BSP_MAX_QUEUE_SIZE, maxQueueSize);
            return this;
        }

        public Builder setMaxExportBatchSize(long maxExportBatchSize) {
            this.addValue(WildFlyOpenTelemetryConfig.OTEL_BSP_MAX_EXPORT_BATCH_SIZE, maxExportBatchSize);
            return this;
        }

        public Builder setSampler(String sampler) {
            if (sampler != null) {
                switch (sampler) {
                    case "on": {
                        this.addValue(WildFlyOpenTelemetryConfig.OTEL_TRACES_SAMPLER, "always_on");
                        break;
                    }
                    case "off": {
                        this.addValue(WildFlyOpenTelemetryConfig.OTEL_TRACES_SAMPLER, "always_off");
                        break;
                    }
                    case "ratio": {
                        this.addValue(WildFlyOpenTelemetryConfig.OTEL_TRACES_SAMPLER, "traceidratio");
                    }
                }
            }
            return this;
        }

        public Builder setSamplerRatio(Double ratio) {
            this.addValue(WildFlyOpenTelemetryConfig.OTEL_TRACES_SAMPLER_ARG, ratio);
            return this;
        }

        public Builder setInjectVertx(boolean injectVertx) {
            if (injectVertx) {
                this.addValue("otel.exporter.vertx.cdi.identifier", "vertx");
            }
            return this;
        }

        public Builder setMicroProfileTelemetryInstalled(boolean microProfileTelemetryInstalled) {
            this.mpTelemetryInstalled = microProfileTelemetryInstalled;
            return this;
        }

        public WildFlyOpenTelemetryConfig build() {
            return new WildFlyOpenTelemetryConfig(this.properties, this.mpTelemetryInstalled);
        }

        private void addValue(String key, Object value) {
            if (value != null) {
                this.properties.put(key, value.toString());
            }
        }
    }
}

