/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.parser.servlet;

import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.annotation.javaee.Descriptions;
import org.jboss.metadata.javaee.spec.DescriptionsImpl;
import org.jboss.metadata.javaee.support.IdMetaData;
import org.jboss.metadata.parser.ee.DescriptionsMetaDataParser;
import org.jboss.metadata.parser.ee.IdMetaDataParser;
import org.jboss.metadata.parser.servlet.AbstractVersionedMetaDataParser;
import org.jboss.metadata.parser.servlet.Element;
import org.jboss.metadata.parser.servlet.Version;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.metadata.web.spec.AttributeValueMetaData;
import org.jboss.metadata.web.spec.CookieConfigMetaData;

public class CookieConfigMetaDataParser
extends AbstractVersionedMetaDataParser<CookieConfigMetaData> {
    private static final String ATTRIBUTE_NAME = "attribute-name";
    private static final String ATTRIBUTE_VALUE = "attribute-value";

    CookieConfigMetaDataParser(Version version) {
        super(version);
    }

    public CookieConfigMetaData parse(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        CookieConfigMetaData cookieConfig = new CookieConfigMetaData();
        IdMetaDataParser.parseAttributes((XMLStreamReader)reader, (IdMetaData)cookieConfig);
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case NAME: {
                    cookieConfig.setName(CookieConfigMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    continue block12;
                }
                case DOMAIN: {
                    cookieConfig.setDomain(CookieConfigMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    continue block12;
                }
                case PATH: {
                    cookieConfig.setPath(CookieConfigMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    continue block12;
                }
                case COMMENT: {
                    cookieConfig.setComment(CookieConfigMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    continue block12;
                }
                case HTTP_ONLY: {
                    if (Boolean.TRUE.equals(Boolean.valueOf(CookieConfigMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer)))) {
                        cookieConfig.setHttpOnly(true);
                        continue block12;
                    }
                    cookieConfig.setHttpOnly(false);
                    continue block12;
                }
                case SECURE: {
                    if (Boolean.TRUE.equals(Boolean.valueOf(CookieConfigMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer)))) {
                        cookieConfig.setSecure(true);
                        continue block12;
                    }
                    cookieConfig.setSecure(false);
                    continue block12;
                }
                case MAX_AGE: {
                    try {
                        cookieConfig.setMaxAge(Integer.valueOf(CookieConfigMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer)));
                        continue block12;
                    }
                    catch (NumberFormatException e) {
                        throw CookieConfigMetaDataParser.unexpectedValue((XMLStreamReader)reader, (Throwable)e);
                    }
                }
                case ATTRIBUTE: {
                    if (!this.since(Version.SERVLET_6_0)) break;
                    List<AttributeValueMetaData> attributes = cookieConfig.getAttributes();
                    if (attributes == null) {
                        attributes = new LinkedList<AttributeValueMetaData>();
                        cookieConfig.setAttributes(attributes);
                    }
                    attributes.add(this.parseAttribute(reader, propertyReplacer));
                    continue block12;
                }
            }
            throw CookieConfigMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return cookieConfig;
    }

    protected AttributeValueMetaData parseAttribute(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        AttributeValueMetaData metaData = new AttributeValueMetaData();
        IdMetaDataParser.parseAttributes((XMLStreamReader)reader, (IdMetaData)metaData);
        DescriptionsImpl descriptions = new DescriptionsImpl();
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (reader.getLocalName()) {
                case "attribute-name": {
                    metaData.setAttributeName(CookieConfigMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    continue block8;
                }
                case "attribute-value": {
                    metaData.setAttributeValue(CookieConfigMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    continue block8;
                }
            }
            if (DescriptionsMetaDataParser.parse((XMLStreamReader)reader, (DescriptionsImpl)descriptions, (PropertyReplacer)propertyReplacer)) {
                metaData.setDescriptions((Descriptions)descriptions);
                continue;
            }
            throw CookieConfigMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return metaData;
    }
}

