/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.jboss;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ListIterator;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Unmarshaller;
import org.wildfly.clustering.marshalling.IndexSerializer;
import org.wildfly.clustering.marshalling.IntSerializer;
import org.wildfly.clustering.marshalling.jboss.Writable;

public interface IdentityTable<T> {
    public Writable<T> findWriter(T var1);

    public T read(Unmarshaller var1) throws IOException, ClassNotFoundException;

    public static <T> IdentityTable<T> from(final List<T> entries) {
        final IntSerializer indexSerializer = IndexSerializer.select((int)entries.size());
        final IdentityHashMap<T, Integer> indexes = new IdentityHashMap<T, Integer>(entries.size());
        ListIterator<T> iterator = entries.listIterator();
        while (iterator.hasNext()) {
            indexes.putIfAbsent(iterator.next(), iterator.previousIndex());
        }
        final Writable writer = new Writable<T>(){

            @Override
            public void write(Marshaller marshaller, T value) throws IOException {
                int index = (Integer)indexes.get(value);
                indexSerializer.writeInt((DataOutput)marshaller, index);
            }
        };
        return new IdentityTable<T>(){

            @Override
            public Writable<T> findWriter(T value) {
                return indexes.containsKey(value) ? writer : null;
            }

            @Override
            public T read(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
                int index = indexSerializer.readInt((DataInput)unmarshaller);
                return entries.get(index);
            }
        };
    }
}

