/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands;

import java.util.HashMap;
import org.apache.activemq.artemis.cli.commands.ActionAbstract;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.utils.PasswordMaskingUtil;
import org.apache.activemq.artemis.utils.SensitiveDataCodec;
import picocli.CommandLine;

@CommandLine.Command(name="mask", description={"Mask a password and print it out."})
public class Mask
extends ActionAbstract {
    @CommandLine.Parameters(description={"The password to be masked."})
    String password;
    @CommandLine.Option(names={"--hash"}, description={"Whether to use a hash (one-way). Default: false."})
    boolean hash = false;
    @CommandLine.Option(names={"--key"}, description={"The key (Blowfish) to mask a password."})
    String key;
    @CommandLine.Option(names={"--password-codec"}, description={"Whether to use the password codec defined in the configuration. Default: false"})
    boolean passwordCodec = false;
    private SensitiveDataCodec<String> codec;

    @Override
    public Object execute(ActionContext context) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        if (this.hash) {
            params.put("algorithm", "one-way");
        }
        if (this.key != null) {
            if (this.hash) {
                context.out.println("Option --key ignored in case of hashing");
            } else {
                params.put("key", this.key);
            }
        }
        if (this.passwordCodec) {
            Configuration brokerConfiguration = this.getBrokerConfiguration();
            this.codec = PasswordMaskingUtil.getCodec((String)brokerConfiguration.getPasswordCodec());
        } else {
            this.codec = PasswordMaskingUtil.getDefaultCodec(params);
        }
        String masked = (String)this.codec.encode((Object)this.password);
        context.out.println("result: " + masked);
        return masked;
    }

    @Override
    public boolean isVerbose() {
        return false;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setHash(boolean hash) {
        this.hash = hash;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setPasswordCodec(boolean passwordCodec) {
        this.passwordCodec = passwordCodec;
    }

    public SensitiveDataCodec<String> getCodec() {
        return this.codec;
    }
}

