/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client;

import java.io.BufferedInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationImpl;
import org.jboss.as.controller.client.impl.InputStreamEntry;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.dmr.ModelNode;
import org.wildfly.common.Assert;

public class OperationBuilder {
    private final ModelNode operation;
    private volatile List<InputStream> inputStreams;
    private boolean autoCloseStreams = false;

    public OperationBuilder(ModelNode operation) {
        this(operation, false);
    }

    public OperationBuilder(ModelNode operation, boolean autoCloseStreams) {
        Assert.checkNotNullParam((String)"operation", (Object)operation);
        this.operation = operation;
        this.autoCloseStreams = autoCloseStreams;
    }

    public OperationBuilder addFileAsAttachment(File file) {
        Assert.checkNotNullParam((String)"file", (Object)file);
        try {
            FileStreamEntry entry = new FileStreamEntry(file);
            if (this.inputStreams == null) {
                this.inputStreams = new ArrayList<InputStream>();
            }
            this.inputStreams.add(entry);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public OperationBuilder addFileAsAttachment(Path file) {
        Assert.checkNotNullParam((String)"file", (Object)file);
        try {
            FileStreamEntry entry = new FileStreamEntry(file);
            if (this.inputStreams == null) {
                this.inputStreams = new ArrayList<InputStream>();
            }
            this.inputStreams.add(entry);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public OperationBuilder addInputStream(InputStream in) {
        Assert.checkNotNullParam((String)"in", (Object)in);
        if (this.inputStreams == null) {
            this.inputStreams = new ArrayList<InputStream>();
        }
        this.inputStreams.add(in);
        return this;
    }

    public int getInputStreamCount() {
        List<InputStream> list = this.inputStreams;
        return list == null ? 0 : list.size();
    }

    public void setAutoCloseStreams(boolean autoCloseStreams) {
        this.autoCloseStreams = autoCloseStreams;
    }

    public Operation build() {
        return new OperationImpl(this.operation, this.inputStreams, this.autoCloseStreams);
    }

    public static OperationBuilder create(ModelNode operation) {
        return new OperationBuilder(operation);
    }

    public static OperationBuilder create(ModelNode operation, boolean autoCloseStreams) {
        return new OperationBuilder(operation, autoCloseStreams);
    }

    private static class FileStreamEntry
    extends FilterInputStream
    implements InputStreamEntry {
        private final Path file;

        private FileStreamEntry(File file) throws IOException {
            this(file.toPath());
        }

        private FileStreamEntry(Path file) throws IOException {
            super(Files.newInputStream(file, new OpenOption[0]));
            this.file = file;
        }

        @Override
        public int initialize() throws IOException {
            return (int)Files.size(this.file);
        }

        @Override
        public void copyStream(DataOutput output) throws IOException {
            try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(this.file, new OpenOption[0]));){
                StreamUtils.copyStream((InputStream)in, (DataOutput)output);
            }
        }
    }
}

