/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.concurrent.CompletableFuture;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.controller.client.ModelControllerClientConfiguration;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.as.controller.client.helpers.ContextualModelControllerClient;
import org.jboss.as.controller.client.impl.RemotingModelControllerClient;
import org.jboss.as.controller.client.logging.ControllerClientLogger;
import org.jboss.dmr.ModelNode;
import org.wildfly.client.config.ConfigXMLParseException;
import org.wildfly.common.context.Contextual;
import org.wildfly.security.auth.client.ElytronXmlParser;

public interface ModelControllerClient
extends Closeable {
    default public ModelNode execute(ModelNode operation) throws IOException {
        return this.execute(Operation.Factory.create(operation), OperationMessageHandler.DISCARD);
    }

    default public ModelNode execute(Operation operation) throws IOException {
        return this.execute(operation, OperationMessageHandler.DISCARD);
    }

    default public ModelNode execute(ModelNode operation, OperationMessageHandler messageHandler) throws IOException {
        return this.execute(Operation.Factory.create(operation), messageHandler);
    }

    default public ModelNode execute(Operation operation, OperationMessageHandler messageHandler) throws IOException {
        try (OperationResponse or = this.executeOperation(operation, messageHandler);){
            ModelNode modelNode = or.getResponseNode();
            return modelNode;
        }
    }

    public OperationResponse executeOperation(Operation var1, OperationMessageHandler var2) throws IOException;

    default public CompletableFuture<ModelNode> executeAsync(ModelNode operation) {
        return this.executeAsync(Operation.Factory.create(operation), OperationMessageHandler.DISCARD);
    }

    default public CompletableFuture<ModelNode> executeAsync(ModelNode operation, OperationMessageHandler messageHandler) {
        return this.executeAsync(Operation.Factory.create(operation), messageHandler);
    }

    default public CompletableFuture<ModelNode> executeAsync(Operation operation) {
        return this.executeAsync(operation, OperationMessageHandler.DISCARD);
    }

    public CompletableFuture<ModelNode> executeAsync(Operation var1, OperationMessageHandler var2);

    public CompletableFuture<OperationResponse> executeOperationAsync(Operation var1, OperationMessageHandler var2);

    public static class Factory {
        public static ModelControllerClient create(InetAddress address, int port) {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setHostName(address.getHostAddress()).setPort(port).build());
        }

        public static ModelControllerClient create(String protocol, InetAddress address, int port) {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setHostName(address.getHostAddress()).setPort(port).setProtocol(protocol).build());
        }

        public static ModelControllerClient create(InetAddress address, int port, CallbackHandler handler) {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setHandler(handler).setHostName(address.getHostAddress()).setPort(port).build());
        }

        public static ModelControllerClient create(String protocol, InetAddress address, int port, CallbackHandler handler) {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setHandler(handler).setHostName(address.getHostAddress()).setPort(port).setProtocol(protocol).build());
        }

        public static ModelControllerClient create(String hostName, int port) throws UnknownHostException {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setHostName(hostName).setPort(port).build());
        }

        public static ModelControllerClient create(String protocol, String hostName, int port) throws UnknownHostException {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setHostName(hostName).setPort(port).setProtocol(protocol).build());
        }

        public static ModelControllerClient create(String hostName, int port, CallbackHandler handler) throws UnknownHostException {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setHandler(handler).setHostName(hostName).setPort(port).build());
        }

        public static ModelControllerClient create(String protocol, String hostName, int port, CallbackHandler handler) throws UnknownHostException {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setHandler(handler).setHostName(hostName).setPort(port).setProtocol(protocol).build());
        }

        public static ModelControllerClient create(ModelControllerClientConfiguration configuration) {
            RemotingModelControllerClient result = RemotingModelControllerClient.create(configuration);
            Contextual contextual = null;
            URI authenticationConfig = configuration.getAuthenticationConfigUri();
            if (authenticationConfig != null) {
                try {
                    contextual = (Contextual)ElytronXmlParser.parseAuthenticationClientConfiguration((URI)authenticationConfig).create();
                }
                catch (GeneralSecurityException | ConfigXMLParseException e) {
                    throw ControllerClientLogger.ROOT_LOGGER.failedToParseAuthenticationConfig(e, authenticationConfig);
                }
            }
            if (contextual == null) {
                return result;
            }
            return new ContextualModelControllerClient(result, contextual);
        }
    }
}

