/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server.logging;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.as.domain.http.server.logging.HttpServerLogger;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleNotFoundException;

public class HttpServerLogger_$logger
extends DelegatingBasicLogger
implements HttpServerLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = HttpServerLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public HttpServerLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void modelRequestError(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.modelRequestError$str(), new Object[0]);
    }

    protected String modelRequestError$str() {
        return "WFLYDMHTTP0001: Unexpected error executing model request";
    }

    @Override
    public final void uploadError(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.uploadError$str(), new Object[0]);
    }

    protected String uploadError$str() {
        return "WFLYDMHTTP0002: Unexpected error executing deployment upload request";
    }

    @Override
    public final void consoleModuleNotFound(String slot) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.consoleModuleNotFound$str(), (Object)slot);
    }

    protected String consoleModuleNotFound$str() {
        return "WFLYDMHTTP0003: Unable to load console module for slot %s, disabling console";
    }

    @Override
    public final void errorContextModuleNotFound(String slot) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.errorContextModuleNotFound$str(), (Object)slot);
    }

    protected String errorContextModuleNotFound$str() {
        return "WFLYDMHTTP0004: Unable to load error context for slot %s, disabling error context.";
    }

    protected String invalidOperation$str() {
        return "WFLYDMHTTP0005: Invalid operation '%s'";
    }

    @Override
    public final IllegalArgumentException invalidOperation(Throwable cause, String value) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidOperation$str(), value), cause);
        HttpServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    protected String realmNotReadyMessage$str() {
        return "WFLYDMHTTP0006: The security realm is not ready to process requests, see %s";
    }

    @Override
    public final String realmNotReadyMessage(String url) {
        return String.format(this.getLoggingLocale(), this.realmNotReadyMessage$str(), url);
    }

    protected String consoleModuleNotFoundMsg$str() {
        return "WFLYDMHTTP0007: No console module available with module name %s";
    }

    @Override
    public final ModuleNotFoundException consoleModuleNotFoundMsg(String moduleName) {
        ModuleNotFoundException result = new ModuleNotFoundException(String.format(this.getLoggingLocale(), this.consoleModuleNotFoundMsg$str(), moduleName));
        HttpServerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidCredentialType$str() {
        return "WFLYDMHTTP0010: Invalid Credential Type '%s'";
    }

    @Override
    public final IllegalArgumentException invalidCredentialType(String value) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidCredentialType$str(), value));
        HttpServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void httpsRedirectNotSupported(InetAddress bindAddress, InetAddress secureBindAddress) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.httpsRedirectNotSupported$str(), (Object)bindAddress, (Object)secureBindAddress);
    }

    protected String httpsRedirectNotSupported$str() {
        return "WFLYDMHTTP0011: Management interface is using different addresses for HTTP (%s) and HTTPS (%s). Redirection of HTTPS requests from HTTP socket to HTTPS socket will not be supported.";
    }

    protected String sslRequestedNoSslContext$str() {
        return "WFLYDMHTTP0012: A secure socket has been defined for the HTTP interface, however the referenced security realm is not supplying a SSLContext.";
    }

    @Override
    public final IllegalArgumentException sslRequestedNoSslContext() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.sslRequestedNoSslContext$str(), new Object[0]));
        HttpServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidUseStreamAsResponseIndex$str() {
        return "WFLYDMHTTP0013: Invalid useStreamIndex value '%d'. The operation response had %d streams attached.";
    }

    @Override
    public final String invalidUseStreamAsResponseIndex(int index, int available) {
        return String.format(this.getLoggingLocale(), this.invalidUseStreamAsResponseIndex$str(), index, available);
    }

    protected String managementHttpServerAlreadyBuild$str() {
        return "WFLYDMHTTP0014: The ManagementHttpServer has already been built using this Builder.";
    }

    @Override
    public final IllegalStateException managementHttpServerAlreadyBuild() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.managementHttpServerAlreadyBuild$str(), new Object[0]));
        HttpServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noRealmOrSSLContext$str() {
        return "WFLYDMHTTP0015: No SecurityRealm or SSLContext has been provided.";
    }

    @Override
    public final IllegalStateException noRealmOrSSLContext() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noRealmOrSSLContext$str(), new Object[0]));
        HttpServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String realmNotReadyForSecuredManagementHandler$str() {
        return "WFLYDMHTTP0016: Your Application Server is running. However you have not yet added any users to be able to access the HTTP management interface. To add a new user execute the %s script within the bin folder of your WildFly installation and enter the requested information. By default the realm name used by WildFly is 'ManagementRealm' and this is already selected by default by the add-user tool.";
    }

    @Override
    public final String realmNotReadyForSecuredManagementHandler(String scriptFile) {
        return String.format(this.getLoggingLocale(), this.realmNotReadyForSecuredManagementHandler$str(), scriptFile);
    }
}

