/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.clustering.jgroups.subsystem.AbstractProtocolResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolConfigurationResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.StackResourceDefinitionRegistrar;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.operations.global.MapOperations;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.dmr.ModelNode;
import org.jgroups.PhysicalAddress;
import org.jgroups.protocols.Discovery;
import org.jgroups.stack.IpAddress;
import org.wildfly.clustering.jgroups.spi.ChannelFactoryConfiguration;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.service.Dependency;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.capability.CapabilityReference;
import org.wildfly.subsystem.resource.capability.CapabilityReferenceListAttributeDefinition;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ServiceDependency;

public class SocketDiscoveryProtocolResourceDefinitionRegistrar<A, P extends Discovery>
extends AbstractProtocolResourceDefinitionRegistrar<P> {
    static final CapabilityReferenceListAttributeDefinition<OutboundSocketBinding> OUTBOUND_SOCKET_BINDINGS = ((CapabilityReferenceListAttributeDefinition.Builder)((CapabilityReferenceListAttributeDefinition.Builder)new CapabilityReferenceListAttributeDefinition.Builder("socket-bindings", CapabilityReference.builder((RuntimeCapability)CAPABILITY, (UnaryServiceDescriptor)OutboundSocketBinding.SERVICE_DESCRIPTOR).build()).setMinSize(1)).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.SOCKET_BINDING_REF})).build();
    private final Function<InetSocketAddress, A> hostTransformer;

    SocketDiscoveryProtocolResourceDefinitionRegistrar(final Protocol registration, Function<InetSocketAddress, A> hostTransformer, final ResourceOperationRuntimeHandler parentRuntimeHandler) {
        super(new AbstractProtocolResourceDefinitionRegistrar.Configurator(){

            @Override
            public ResourceRegistration getResourceRegistration() {
                return registration;
            }

            @Override
            public ResourceOperationRuntimeHandler getParentRuntimeHandler() {
                return parentRuntimeHandler;
            }
        });
        this.hostTransformer = hostTransformer;
    }

    @Override
    public ResourceDescriptor.Builder apply(ResourceDescriptor.Builder builder) {
        return (ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)super.apply(builder).addAttributes(List.of(OUTBOUND_SOCKET_BINDINGS))).withOperationTransformation("add", (UnaryOperator)new AbstractProtocolResourceDefinitionRegistrar.LegacyAddOperationTransformation(List.of(OUTBOUND_SOCKET_BINDINGS)))).withOperationTransformation(Set.of("remove", MapOperations.MAP_GET_DEFINITION.getName(), MapOperations.MAP_PUT_DEFINITION.getName(), MapOperations.MAP_REMOVE_DEFINITION.getName(), MapOperations.MAP_CLEAR_DEFINITION.getName()), LEGACY_OPERATION_TRANSFORMER);
    }

    @Override
    public ServiceDependency<ProtocolConfiguration<P>> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        return super.resolve(context, model).combine((Dependency)OUTBOUND_SOCKET_BINDINGS.resolve(context, model), new BiFunction<ProtocolConfiguration<P>, List<OutboundSocketBinding>, ProtocolConfiguration<P>>(){

            @Override
            public ProtocolConfiguration<P> apply(ProtocolConfiguration<P> config, final List<OutboundSocketBinding> bindings) {
                return new ProtocolConfigurationResourceDefinitionRegistrar.ProtocolConfigurationDecorator<P>(config){

                    @Override
                    public P createProtocol(ChannelFactoryConfiguration stackConfiguration) {
                        Discovery protocol = (Discovery)super.createProtocol(stackConfiguration);
                        if (!bindings.isEmpty()) {
                            ArrayList initialHosts = new ArrayList(bindings.size());
                            for (OutboundSocketBinding binding : bindings) {
                                try {
                                    initialHosts.add(SocketDiscoveryProtocolResourceDefinitionRegistrar.this.hostTransformer.apply(new InetSocketAddress(binding.getResolvedDestinationAddress(), binding.getDestinationPort())));
                                }
                                catch (UnknownHostException e) {
                                    throw JGroupsLogger.ROOT_LOGGER.failedToResolveSocketBinding(e, binding);
                                }
                            }
                            this.setValue(protocol, "initial_hosts", initialHosts);
                        }
                        return protocol;
                    }
                };
            }
        });
    }

    static enum Protocol implements ResourceRegistration
    {
        TCPGOSSIP(InetSocketAddress.class, Function.identity()),
        TCPPING(PhysicalAddress.class, address -> new IpAddress(address.getAddress(), address.getPort()));

        private final PathElement path = StackResourceDefinitionRegistrar.Component.PROTOCOL.pathElement(this.name());
        private final Function<InetSocketAddress, ?> hostTransformer;

        private <A> Protocol(Class<A> hostClass, Function<InetSocketAddress, A> hostTransformer) {
            this.hostTransformer = hostTransformer;
        }

        Function<InetSocketAddress, ?> getHostTransformer() {
            return this.hostTransformer;
        }

        public PathElement getPathElement() {
            return this.path;
        }
    }
}

