/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import org.jboss.as.clustering.jgroups.subsystem.AbstractProtocolResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolConfigurationResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.SocketProtocolResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.SocketProtocolResourceRegistration;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.RequirementServiceBuilder;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.network.ClientMapping;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jgroups.protocols.FD_SOCK2;
import org.wildfly.clustering.jgroups.spi.ChannelFactoryConfiguration;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.clustering.jgroups.spi.TransportConfiguration;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ServiceDependency;

public class FailureDetectionProtocolResourceDefinitionRegistrar
extends SocketProtocolResourceDefinitionRegistrar<FD_SOCK2> {
    FailureDetectionProtocolResourceDefinitionRegistrar(final SocketProtocolResourceRegistration registration, final ResourceOperationRuntimeHandler parentRuntimeHandler) {
        super(new AbstractProtocolResourceDefinitionRegistrar.Configurator(){

            @Override
            public ResourceRegistration getResourceRegistration() {
                return registration;
            }

            @Override
            public ResourceOperationRuntimeHandler getParentRuntimeHandler() {
                return parentRuntimeHandler;
            }
        });
    }

    @Override
    public ServiceDependency<ProtocolConfiguration<FD_SOCK2>> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        final ServiceDependency protocol = super.resolve(context, model);
        final ServiceDependency<SocketBinding> serverBinding = SocketProtocolResourceDefinitionRegistrar.SocketBindingAttribute.SERVER.resolve(context, model);
        final ServiceDependency<SocketBinding> clientBinding = SocketProtocolResourceDefinitionRegistrar.SocketBindingAttribute.CLIENT.resolve(context, model);
        final ServiceDependency transport = (ServiceDependency)TRANSPORT.resolve(context, model);
        return new ServiceDependency<ProtocolConfiguration<FD_SOCK2>>(){

            public void accept(RequirementServiceBuilder<?> builder) {
                protocol.accept(builder);
                serverBinding.accept(builder);
                clientBinding.accept(builder);
                transport.accept(builder);
            }

            public ProtocolConfiguration<FD_SOCK2> get() {
                return new ProtocolConfigurationResourceDefinitionRegistrar.ProtocolConfigurationDecorator<FD_SOCK2>((ProtocolConfiguration)protocol.get()){

                    @Override
                    public FD_SOCK2 createProtocol(ChannelFactoryConfiguration stackConfiguration) {
                        SocketBinding clientSocketBinding;
                        FD_SOCK2 protocol = (FD_SOCK2)super.createProtocol(stackConfiguration);
                        SocketBinding protocolBinding = (SocketBinding)serverBinding.get();
                        SocketBinding transportBinding = ((TransportConfiguration)transport.get()).getSocketBinding();
                        InetSocketAddress protocolBindAddress = protocolBinding != null ? protocolBinding.getSocketAddress() : null;
                        InetSocketAddress transportBindAddress = transportBinding.getSocketAddress();
                        protocol.setBindAddress((protocolBindAddress != null ? protocolBindAddress : transportBindAddress).getAddress());
                        if (protocolBinding != null) {
                            protocol.setOffset(protocolBindAddress.getPort() - transportBindAddress.getPort());
                            List clientMappings = protocolBinding.getClientMappings();
                            if (!clientMappings.isEmpty()) {
                                ClientMapping mapping = (ClientMapping)clientMappings.get(0);
                                try {
                                    protocol.setExternalAddress(InetAddress.getByName(mapping.getDestinationAddress()));
                                    protocol.setExternalPort(mapping.getDestinationPort());
                                }
                                catch (UnknownHostException e) {
                                    throw new IllegalArgumentException(e);
                                }
                            }
                        }
                        if ((clientSocketBinding = (SocketBinding)clientBinding.get()) != null) {
                            protocol.setClientBindPort(((SocketBinding)clientBinding.get()).getSocketAddress().getPort());
                        }
                        return protocol;
                    }

                    @Override
                    public Map<String, SocketBinding> getSocketBindings() {
                        SocketBinding socketBinding = (SocketBinding)serverBinding.get();
                        return socketBinding != null ? Map.of("jgroups.nio.server.fd_sock", socketBinding) : Map.of();
                    }
                };
            }
        };
    }
}

