/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.user.elytron;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.RequirementServiceTarget;
import org.jboss.as.controller.ServiceNameFactory;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.server.Services;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.protostream.ClassLoaderMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamByteBufferMarshaller;
import org.wildfly.clustering.marshalling.protostream.SerializationContextBuilder;
import org.wildfly.clustering.marshalling.protostream.modules.ModuleClassLoaderMarshaller;
import org.wildfly.clustering.server.manager.Service;
import org.wildfly.clustering.session.user.UserManager;
import org.wildfly.clustering.session.user.UserManagerConfiguration;
import org.wildfly.clustering.session.user.UserManagerFactory;
import org.wildfly.clustering.web.container.SingleSignOnManagerConfiguration;
import org.wildfly.clustering.web.container.SingleSignOnManagerServiceInstallerProvider;
import org.wildfly.clustering.web.service.user.DistributableUserManagementProvider;
import org.wildfly.clustering.web.service.user.LegacyDistributableUserManagementProviderFactory;
import org.wildfly.clustering.web.undertow.logging.UndertowClusteringLogger;
import org.wildfly.clustering.web.undertow.user.elytron.DistributableSingleSignOnManager;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.cache.CachedIdentity;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class DistributableSingleSignOnManagerServiceInstallerProvider
implements SingleSignOnManagerServiceInstallerProvider {
    private final LegacyDistributableUserManagementProviderFactory legacyProviderFactory = ServiceLoader.load(LegacyDistributableUserManagementProviderFactory.class, LegacyDistributableUserManagementProviderFactory.class.getClassLoader()).findFirst().orElseThrow();

    public ResourceServiceInstaller getServiceInstaller(final SingleSignOnManagerConfiguration configuration) {
        final String securityDomainName = configuration.getSecurityDomainName();
        ResourceServiceInstaller providerInstaller = new ResourceServiceInstaller(){

            public Consumer<OperationContext> install(OperationContext context) {
                final ServiceDependency<DistributableUserManagementProvider> provider = DistributableSingleSignOnManagerServiceInstallerProvider.this.getUserManagementProvider(context, securityDomainName);
                return ((ServiceInstaller)((ServiceInstaller.Builder)ServiceInstaller.builder((ServiceInstaller)new ServiceInstaller(){

                    public ServiceController<?> install(RequirementServiceTarget target) {
                        for (ServiceInstaller installer : ((DistributableUserManagementProvider)provider.get()).getServiceInstallers(securityDomainName)) {
                            installer.install((ServiceTarget)target);
                        }
                        return null;
                    }
                }, (CapabilityServiceSupport)context.getCapabilityServiceSupport()).requires(provider)).build()).install(context);
            }
        };
        final ServiceDependency loader = ServiceDependency.on((ServiceName)Services.JBOSS_SERVICE_MODULE_LOADER);
        final ServiceDependency userManagerFactory = ServiceDependency.on((UnaryServiceDescriptor)DistributableUserManagementProvider.USER_MANAGER_FACTORY, (String)securityDomainName);
        UserManagerConfiguration<AtomicReference<SecurityIdentity>> userManagerConfiguration = new UserManagerConfiguration<AtomicReference<SecurityIdentity>>(){

            public org.wildfly.clustering.function.Supplier<String> getIdentifierFactory() {
                return ((Supplier)configuration.getIdentifierGenerator())::get;
            }

            public ByteBufferMarshaller getMarshaller() {
                return new ProtoStreamByteBufferMarshaller((ImmutableSerializationContext)((SerializationContextBuilder)SerializationContextBuilder.newInstance((ClassLoaderMarshaller)new ModuleClassLoaderMarshaller((ModuleLoader)loader.get())).load(WildFlySecurityManager.getClassLoaderPrivileged(this.getClass()))).build());
            }

            public org.wildfly.clustering.function.Supplier<AtomicReference<SecurityIdentity>> getTransientContextFactory() {
                return AtomicReference::new;
            }
        };
        org.wildfly.clustering.function.Supplier<UserManager<CachedIdentity, AtomicReference<SecurityIdentity>, String, Map.Entry<String, URI>>> factory = new org.wildfly.clustering.function.Supplier<UserManager<CachedIdentity, AtomicReference<SecurityIdentity>, String, Map.Entry<String, URI>>>((UserManagerConfiguration)userManagerConfiguration){
            final /* synthetic */ UserManagerConfiguration val$userManagerConfiguration;
            {
                this.val$userManagerConfiguration = userManagerConfiguration;
            }

            public UserManager<CachedIdentity, AtomicReference<SecurityIdentity>, String, Map.Entry<String, URI>> get() {
                return ((UserManagerFactory)userManagerFactory.get()).createUserManager(this.val$userManagerConfiguration);
            }
        };
        ResourceServiceInstaller userManagerInstaller = (ResourceServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder(DistributableSingleSignOnManager::new, (Supplier)factory).provides(ServiceNameFactory.resolveServiceName((UnaryServiceDescriptor)SingleSignOnManagerServiceInstallerProvider.SINGLE_SIGN_ON_MANAGER, (String)securityDomainName))).requires(List.of(loader, userManagerFactory))).onStart(Service::start)).onStop(Service::stop)).build();
        return ResourceServiceInstaller.combine((ResourceServiceInstaller[])new ResourceServiceInstaller[]{providerInstaller, userManagerInstaller});
    }

    ServiceDependency<DistributableUserManagementProvider> getUserManagementProvider(OperationContext context, String securityDomainName) {
        String securityDomainCapabilityName = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.undertow.application-security-domain", (String)securityDomainName);
        if (context.hasOptionalCapability(RuntimeCapability.resolveCapabilityName((UnaryServiceDescriptor)DistributableUserManagementProvider.SERVICE_DESCRIPTOR, (String)securityDomainName), securityDomainCapabilityName, null)) {
            return ServiceDependency.on((UnaryServiceDescriptor)DistributableUserManagementProvider.SERVICE_DESCRIPTOR, (String)securityDomainName);
        }
        if (context.hasOptionalCapability(DistributableUserManagementProvider.DEFAULT_SERVICE_DESCRIPTOR.getName(), securityDomainCapabilityName, null)) {
            return ServiceDependency.on((NullaryServiceDescriptor)DistributableUserManagementProvider.DEFAULT_SERVICE_DESCRIPTOR);
        }
        UndertowClusteringLogger.ROOT_LOGGER.legacySingleSignOnProviderInUse(securityDomainName);
        return ServiceDependency.of((Object)this.legacyProviderFactory.createUserManagementProvider());
    }
}

