/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.routing;

import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.RequirementServiceTarget;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.web.service.routing.LegacyRoutingProviderFactory;
import org.wildfly.clustering.web.service.routing.RoutingProvider;
import org.wildfly.clustering.web.undertow.logging.UndertowClusteringLogger;
import org.wildfly.extension.undertow.Server;
import org.wildfly.extension.undertow.ServerServiceInstallerProvider;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class RoutingServiceInstallerProvider
implements ServerServiceInstallerProvider {
    private final LegacyRoutingProviderFactory legacyProviderFactory;

    public RoutingServiceInstallerProvider() {
        Iterator<LegacyRoutingProviderFactory> factories = ServiceLoader.load(LegacyRoutingProviderFactory.class, LegacyRoutingProviderFactory.class.getClassLoader()).iterator();
        if (!factories.hasNext()) {
            throw new ServiceConfigurationError(LegacyRoutingProviderFactory.class.getName());
        }
        this.legacyProviderFactory = factories.next();
    }

    public ResourceServiceInstaller getServiceInstaller(final String serverName) {
        return new ResourceServiceInstaller(){

            public Consumer<OperationContext> install(OperationContext context) {
                final ServiceDependency<RoutingProvider> provider = RoutingServiceInstallerProvider.this.getRoutingProvider(context, serverName);
                ServiceInstaller installer = new ServiceInstaller(){

                    public ServiceController<?> install(RequirementServiceTarget target) {
                        ServiceDependency serverId = ServiceDependency.on((UnaryServiceDescriptor)Server.SERVICE_DESCRIPTOR, (String)serverName).map(Server::getRoute);
                        for (ServiceInstaller installer : ((RoutingProvider)provider.get()).getServiceInstallers(serverName, serverId)) {
                            installer.install((ServiceTarget)target);
                        }
                        return null;
                    }
                };
                return ((ServiceInstaller)((ServiceInstaller.Builder)ServiceInstaller.builder((ServiceInstaller)installer, (CapabilityServiceSupport)context.getCapabilityServiceSupport()).requires(provider)).build()).install(context);
            }
        };
    }

    private ServiceDependency<RoutingProvider> getRoutingProvider(OperationContext context, String serverName) {
        if (context.hasOptionalCapability(RoutingProvider.SERVICE_DESCRIPTOR.getName(), RuntimeCapability.resolveCapabilityName((UnaryServiceDescriptor)Server.SERVICE_DESCRIPTOR, (String)serverName), null)) {
            return ServiceDependency.on((NullaryServiceDescriptor)RoutingProvider.SERVICE_DESCRIPTOR);
        }
        UndertowClusteringLogger.ROOT_LOGGER.legacyRoutingProviderInUse(serverName);
        return ServiceDependency.of((Object)this.legacyProviderFactory.createRoutingProvider());
    }
}

