/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem.remote;

import java.util.List;
import java.util.function.Function;
import javax.net.ssl.SSLContext;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.SecurityConfiguration;
import org.infinispan.client.hotrod.configuration.SecurityConfigurationBuilder;
import org.jboss.as.clustering.controller.CommonServiceDescriptor;
import org.jboss.as.clustering.infinispan.subsystem.ConfigurationResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteComponentResourceRegistration;
import org.jboss.as.clustering.infinispan.subsystem.remote.UnaryServiceDescriptorFactory;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.capability.UnaryCapabilityNameResolver;
import org.jboss.dmr.ModelNode;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.capability.CapabilityReference;
import org.wildfly.subsystem.resource.capability.CapabilityReferenceAttributeDefinition;
import org.wildfly.subsystem.service.ServiceDependency;

public class SecurityResourceDefinitionRegistrar
extends ConfigurationResourceDefinitionRegistrar<SecurityConfiguration, SecurityConfigurationBuilder> {
    static final UnaryServiceDescriptor<SecurityConfiguration> SERVICE_DESCRIPTOR = UnaryServiceDescriptorFactory.createServiceDescriptor(RemoteComponentResourceRegistration.SECURITY, SecurityConfiguration.class);
    private static final RuntimeCapability<Void> CAPABILITY = RuntimeCapability.Builder.of(SERVICE_DESCRIPTOR).setDynamicNameMapper((Function)UnaryCapabilityNameResolver.PARENT).setAllowMultipleRegistrations(true).build();
    public static final CapabilityReferenceAttributeDefinition<SSLContext> SSL_CONTEXT = ((CapabilityReferenceAttributeDefinition.Builder)((CapabilityReferenceAttributeDefinition.Builder)new CapabilityReferenceAttributeDefinition.Builder("ssl-context", CapabilityReference.builder(CAPABILITY, (UnaryServiceDescriptor)CommonServiceDescriptor.SSL_CONTEXT).build()).setRequired(false)).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.SSL_REF})).build();

    SecurityResourceDefinitionRegistrar() {
        super(new ConfigurationResourceDefinitionRegistrar.Configurator<SecurityConfiguration>(){

            @Override
            public ResourceRegistration getResourceRegistration() {
                return RemoteComponentResourceRegistration.SECURITY;
            }

            @Override
            public RuntimeCapability<Void> getCapability() {
                return CAPABILITY;
            }
        });
    }

    @Override
    public ResourceDescriptor.Builder apply(ResourceDescriptor.Builder builder) {
        return (ResourceDescriptor.Builder)super.apply(builder).addAttributes(List.of(SSL_CONTEXT));
    }

    public ServiceDependency<SecurityConfigurationBuilder> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        return SSL_CONTEXT.resolve(context, model).map((Function)new Function<SSLContext, SecurityConfigurationBuilder>(){

            @Override
            public SecurityConfigurationBuilder apply(SSLContext context) {
                return new ConfigurationBuilder().security().ssl().hostnameValidation(false).sslContext(context).enabled(context != null).security();
            }
        });
    }
}

