/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem.remote;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import javax.management.MBeanServer;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.client.hotrod.configuration.ClusterConfiguration;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ExecutorFactoryConfiguration;
import org.infinispan.client.hotrod.configuration.SecurityConfiguration;
import org.infinispan.client.hotrod.configuration.ServerConfiguration;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.marshall.Marshaller;
import org.jboss.as.clustering.controller.DurationAttributeDefinition;
import org.jboss.as.clustering.controller.EnumAttributeDefinition;
import org.jboss.as.clustering.controller.MBeanServerResolver;
import org.jboss.as.clustering.controller.ModuleListAttributeDefinition;
import org.jboss.as.clustering.controller.PropertiesAttributeDefinition;
import org.jboss.as.clustering.controller.StatisticsEnabledAttributeDefinition;
import org.jboss.as.clustering.infinispan.jmx.MBeanServerProvider;
import org.jboss.as.clustering.infinispan.logging.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.ConfigurationResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanCacheContainerBindingFactory;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemModel;
import org.jboss.as.clustering.infinispan.subsystem.remote.ClientThreadPool;
import org.jboss.as.clustering.infinispan.subsystem.remote.ClientThreadPoolResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.remote.ConnectionPoolResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.remote.HotRodMarshallerFactory;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteCacheContainerMetric;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteCacheContainerMetricExecutor;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteCacheContainerResource;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteCacheContainerServiceConfigurator;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteCacheRuntimeResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteClusterResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteComponentResourceRegistration;
import org.jboss.as.clustering.infinispan.subsystem.remote.SecurityResourceDefinitionRegistrar;
import org.jboss.as.clustering.naming.BinderServiceInstaller;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RequirementServiceBuilder;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.infinispan.client.RemoteCacheContainer;
import org.wildfly.clustering.infinispan.client.service.HotRodServiceDescriptor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.AttributeDefinitionProvider;
import org.wildfly.subsystem.resource.ManagementResourceRegistrationContext;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.capability.CapabilityReference;
import org.wildfly.subsystem.resource.capability.CapabilityReferenceAttributeDefinition;
import org.wildfly.subsystem.resource.executor.MetricExecutor;
import org.wildfly.subsystem.resource.executor.MetricOperationStepHandler;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;
import org.wildfly.subsystem.service.capture.FunctionExecutorRegistry;
import org.wildfly.subsystem.service.capture.ServiceValueExecutorRegistry;

public class RemoteCacheContainerResourceDefinitionRegistrar
extends ConfigurationResourceDefinitionRegistrar<Configuration, ConfigurationBuilder>
implements ResourceServiceConfigurator {
    public static final ResourceRegistration REGISTRATION = ResourceRegistration.of((PathElement)PathElement.pathElement((String)"remote-cache-container"));
    private static final RuntimeCapability<Void> CAPABILITY = RuntimeCapability.Builder.of((UnaryServiceDescriptor)HotRodServiceDescriptor.REMOTE_CACHE_CONTAINER_CONFIGURATION).build();
    public static final ModuleListAttributeDefinition MODULES = new ModuleListAttributeDefinition.Builder().setDefaultValue(Module.forClass(RemoteCacheContainer.class)).build();
    public static final DurationAttributeDefinition CONNECTION_TIMEOUT = new DurationAttributeDefinition.Builder("connection-timeout", ChronoUnit.MILLIS).setDefaultValue(Duration.ofMinutes(1L)).build();
    public static final DurationAttributeDefinition SOCKET_TIMEOUT = new DurationAttributeDefinition.Builder("socket-timeout", ChronoUnit.MILLIS).setDefaultValue(Duration.ofMinutes(1L)).build();
    public static final DurationAttributeDefinition TRANSACTION_TIMEOUT = new DurationAttributeDefinition.Builder("transaction-timeout", ChronoUnit.MILLIS).setDefaultValue(Duration.ofMinutes(1L)).build();
    public static final CapabilityReferenceAttributeDefinition<ClusterConfiguration> DEFAULT_REMOTE_CLUSTER = ((CapabilityReferenceAttributeDefinition.Builder)new CapabilityReferenceAttributeDefinition.Builder("default-remote-cluster", CapabilityReference.builder(CAPABILITY, RemoteClusterResourceDefinitionRegistrar.SERVICE_DESCRIPTOR).withParentPath(REGISTRATION.getPathElement()).build()).setRequired(false)).build();
    public static final EnumAttributeDefinition<HotRodMarshallerFactory> MARSHALLER = new EnumAttributeDefinition.Builder("marshaller", (Enum)HotRodMarshallerFactory.LEGACY).build();
    public static final EnumAttributeDefinition<ProtocolVersion> PROTOCOL_VERSION = new EnumAttributeDefinition.Builder("protocol-version", (Enum)ProtocolVersion.PROTOCOL_VERSION_41).setAllowedValues(EnumSet.complementOf(EnumSet.of(ProtocolVersion.PROTOCOL_VERSION_AUTO))).withResolver(ProtocolVersion::parseVersion).build();
    public static final PropertiesAttributeDefinition PROPERTIES = new PropertiesAttributeDefinition.Builder("properties").build();
    public static final StatisticsEnabledAttributeDefinition STATISTICS_ENABLED = new StatisticsEnabledAttributeDefinition.Builder().build();
    private final ServiceValueExecutorRegistry<RemoteCacheContainer> registry = ServiceValueExecutorRegistry.newInstance();

    public RemoteCacheContainerResourceDefinitionRegistrar() {
        super(new ConfigurationResourceDefinitionRegistrar.Configurator<Configuration>(){

            @Override
            public ResourceRegistration getResourceRegistration() {
                return REGISTRATION;
            }

            @Override
            public RuntimeCapability<Void> getCapability() {
                return CAPABILITY;
            }
        });
    }

    @Override
    public ResourceDescriptor.Builder apply(ResourceDescriptor.Builder builder) {
        return (ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)super.apply(builder).addAttributes(List.of(MODULES, CONNECTION_TIMEOUT, SOCKET_TIMEOUT, TRANSACTION_TIMEOUT, DEFAULT_REMOTE_CLUSTER, MARSHALLER, PROTOCOL_VERSION, PROPERTIES, STATISTICS_ENABLED))).provideAttributes(EnumSet.allOf(Attribute.class))).addCapability(RemoteCacheContainerServiceConfigurator.CAPABILITY)).requireChildResources(Set.of(ClientThreadPool.ASYNC, RemoteComponentResourceRegistration.SECURITY))).withResourceTransformation(RemoteCacheContainerResource::new);
    }

    @Override
    public ManagementResourceRegistration register(ManagementResourceRegistration parent, ManagementResourceRegistrationContext context) {
        ManagementResourceRegistration registration = super.register(parent, context);
        new ConnectionPoolResourceDefinitionRegistrar().register(registration, context);
        new RemoteClusterResourceDefinitionRegistrar(super.get(), (FunctionExecutorRegistry<RemoteCacheContainer>)this.registry).register(registration, context);
        new SecurityResourceDefinitionRegistrar().register(registration, context);
        for (ClientThreadPool pool : EnumSet.allOf(ClientThreadPool.class)) {
            new ClientThreadPoolResourceDefinitionRegistrar(pool).register(registration, context);
        }
        if (context.isRuntimeOnlyRegistrationValid()) {
            new MetricOperationStepHandler((MetricExecutor)new RemoteCacheContainerMetricExecutor((FunctionExecutorRegistry<RemoteCacheContainer>)this.registry), RemoteCacheContainerMetric.class).register(registration);
            new RemoteCacheRuntimeResourceDefinitionRegistrar((FunctionExecutorRegistry<RemoteCacheContainer>)this.registry).register(registration, context);
        }
        return registration;
    }

    @Override
    public ResourceOperationRuntimeHandler get() {
        return ResourceOperationRuntimeHandler.combine((ResourceOperationRuntimeHandler[])new ResourceOperationRuntimeHandler[]{super.get(), ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this)});
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        String name = context.getCurrentAddressValue();
        ServiceInstaller captureInstaller = this.registry.capture(ServiceDependency.on((UnaryServiceDescriptor)HotRodServiceDescriptor.REMOTE_CACHE_CONTAINER, (String)name));
        ResourceServiceInstaller containerInstaller = RemoteCacheContainerServiceConfigurator.INSTANCE.configure(context, model);
        BinderServiceInstaller bindingInstaller = new BinderServiceInstaller(InfinispanCacheContainerBindingFactory.REMOTE.apply(name), context.getCapabilityServiceName(HotRodServiceDescriptor.REMOTE_CACHE_CONTAINER, name));
        return ResourceServiceInstaller.combine((ResourceServiceInstaller[])new ResourceServiceInstaller[]{captureInstaller, containerInstaller, bindingInstaller});
    }

    public ServiceDependency<ConfigurationBuilder> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        final String name = context.getCurrentAddressValue();
        final ServiceDependency defaultRemoteCluster = DEFAULT_REMOTE_CLUSTER.resolve(context, model);
        final ProtocolVersion version = (ProtocolVersion)PROTOCOL_VERSION.resolve(context, model);
        final BiFunction marshallerFactory = (BiFunction)((Object)MARSHALLER.resolve(context, model));
        final Duration connectionTimeout = CONNECTION_TIMEOUT.resolve(context, model);
        final Duration socketTimeout = SOCKET_TIMEOUT.resolve(context, model);
        final Duration transactionTimeout = TRANSACTION_TIMEOUT.resolve(context, model);
        final int maxRetries = Attribute.MAX_RETRIES.resolveModelAttribute((ExpressionResolver)context, model).asInt();
        final boolean tcpNoDelay = Attribute.TCP_NO_DELAY.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        final boolean tcpKeepAlive = Attribute.TCP_KEEP_ALIVE.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        final boolean statisticsEnabled = STATISTICS_ENABLED.resolve(context, model);
        if (marshallerFactory == HotRodMarshallerFactory.LEGACY) {
            InfinispanLogger.ROOT_LOGGER.marshallerEnumValueDeprecated(MARSHALLER.getName(), HotRodMarshallerFactory.LEGACY, EnumSet.complementOf(EnumSet.of(HotRodMarshallerFactory.LEGACY)));
        }
        Resource container = context.readResource(PathAddress.EMPTY_ADDRESS);
        Set entries = container.getChildren(RemoteClusterResourceDefinitionRegistrar.REGISTRATION.getPathElement().getKey());
        final ArrayList<ServiceDependency> remoteClusters = new ArrayList<ServiceDependency>(entries.size());
        for (Resource.ResourceEntry entry : entries) {
            remoteClusters.add(ServiceDependency.on(RemoteClusterResourceDefinitionRegistrar.SERVICE_DESCRIPTOR, (String)name, (String)entry.getName()));
        }
        final ServiceDependency executorFactory = ServiceDependency.on(ClientThreadPool.ASYNC.getServiceDescriptor(), (String)name);
        final ServiceDependency server = new MBeanServerResolver(CAPABILITY).resolve(context, model);
        final ServiceDependency modules = MODULES.resolve(context, model);
        final ServiceDependency security = ServiceDependency.on(SecurityResourceDefinitionRegistrar.SERVICE_DESCRIPTOR, (String)name);
        final ServiceDependency loader = ServiceDependency.on((ServiceName)Services.JBOSS_SERVICE_MODULE_LOADER);
        final Properties properties = new Properties();
        for (Map.Entry entry : PROPERTIES.resolve(context, model).entrySet()) {
            properties.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return new ServiceDependency<ConfigurationBuilder>(){

            public void accept(RequirementServiceBuilder<?> builder) {
                for (ServiceDependency dependency : remoteClusters) {
                    dependency.accept(builder);
                }
                executorFactory.accept(builder);
                server.accept(builder);
                modules.accept(builder);
                security.accept(builder);
                loader.accept(builder);
            }

            public ConfigurationBuilder get() {
                ConfigurationBuilder builder = new ConfigurationBuilder();
                builder.security().read((Object)((SecurityConfiguration)security.get()));
                MBeanServerLookup serverProvider = Optional.ofNullable((MBeanServer)server.get()).map(MBeanServerProvider::new).orElse(null);
                builder.withProperties(properties).connectionTimeout((int)connectionTimeout.toMillis()).maxRetries(maxRetries).version(version).socketTimeout((int)socketTimeout.toMillis()).statistics().enabled(statisticsEnabled).jmxDomain("org.wildfly.clustering.infinispan").jmxEnabled(serverProvider != null).jmxName(name).mBeanServerLookup(serverProvider).tcpNoDelay(tcpNoDelay).tcpKeepAlive(tcpKeepAlive).transactionTimeout(transactionTimeout.toMillis(), TimeUnit.MILLISECONDS);
                Marshaller marshaller = (Marshaller)marshallerFactory.apply((ModuleLoader)loader.get(), (List)modules.get());
                builder.marshaller(marshaller);
                builder.asyncExecutorFactory().read((Object)((ExecutorFactoryConfiguration)executorFactory.get()));
                ClusterConfiguration defaultCluster = (ClusterConfiguration)defaultRemoteCluster.get();
                if (defaultCluster != null) {
                    for (ServerConfiguration server2 : defaultCluster.getCluster()) {
                        builder.addServer().read((Object)server2);
                    }
                }
                for (ServiceDependency remoteCluster : remoteClusters) {
                    ClusterConfiguration cluster = (ClusterConfiguration)remoteCluster.get();
                    String clusterName = cluster.getClusterName();
                    if (defaultCluster != null && clusterName.equals(defaultCluster.getClusterName())) continue;
                    builder.addCluster(clusterName).read((Object)cluster);
                }
                return builder;
            }
        };
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Attribute implements AttributeDefinitionProvider,
    UnaryOperator<SimpleAttributeDefinitionBuilder>
    {
        KEY_SIZE_ESTIMATE("key-size-estimate", ModelType.INT, new ModelNode(64)){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setDeprecated(InfinispanSubsystemModel.VERSION_15_0_0.getVersion());
            }
        }
        ,
        VALUE_SIZE_ESTIMATE("value-size-estimate", ModelType.INT, new ModelNode(512)){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setDeprecated(InfinispanSubsystemModel.VERSION_15_0_0.getVersion());
            }
        }
        ,
        MAX_RETRIES("max-retries", ModelType.INT, new ModelNode(10)),
        TCP_NO_DELAY("tcp-no-delay", ModelType.BOOLEAN, ModelNode.TRUE),
        TCP_KEEP_ALIVE("tcp-keep-alive", ModelType.BOOLEAN, ModelNode.FALSE);

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type, ModelNode defaultValue) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)this.apply(new SimpleAttributeDefinitionBuilder(name, type)).setAllowExpression(true)).setRequired(defaultValue == null)).setDefaultValue(defaultValue)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition get() {
            return this.definition;
        }

        @Override
        public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
            return builder;
        }
    }
}

