/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.infinispan.Cache;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.lock.api.ClusteredLock;
import org.infinispan.lock.api.ClusteredLockConfiguration;
import org.infinispan.lock.api.ClusteredLockManager;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStarted;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStopped;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStartedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;
import org.infinispan.util.concurrent.BlockingManager;
import org.jboss.as.clustering.infinispan.logging.InfinispanLogger;
import org.jboss.as.clustering.infinispan.manager.DefaultCacheContainer;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanCacheContainerBindingFactory;
import org.jboss.as.clustering.naming.BinderServiceInstaller;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceNameFactory;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.infinispan.service.InfinispanServiceDescriptor;
import org.wildfly.clustering.server.Registrar;
import org.wildfly.clustering.server.Registration;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.service.Installer;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;
import org.wildfly.subsystem.service.capture.ServiceValueRegistry;

public class CacheContainerServiceConfigurator
implements ResourceServiceConfigurator {
    static final RuntimeCapability<Void> CAPABILITY = RuntimeCapability.Builder.of((UnaryServiceDescriptor)InfinispanServiceDescriptor.CACHE_CONTAINER).build();
    private final ServiceValueRegistry<EmbeddedCacheManager> containerRegistry;
    private final ServiceValueRegistry<Cache<?, ?>> cacheRegistry;

    public CacheContainerServiceConfigurator(ServiceValueRegistry<EmbeddedCacheManager> containerRegistry, ServiceValueRegistry<Cache<?, ?>> cacheRegistry) {
        this.containerRegistry = containerRegistry;
        this.cacheRegistry = cacheRegistry;
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final String name = context.getCurrentAddressValue();
        List<String> aliases = CacheContainerResourceDefinitionRegistrar.ALIASES.resolveModelAttribute(context, model).asListOrEmpty().stream().map(ModelNode::asString).toList();
        final CacheLifecycleListener listener = new CacheLifecycleListener(name, this.cacheRegistry, (CacheContainerResource)context.readResource(PathAddress.EMPTY_ADDRESS));
        ServiceDependency container = ServiceDependency.on((UnaryServiceDescriptor)InfinispanServiceDescriptor.CACHE_CONTAINER_CONFIGURATION, (String)name).map((Function)new Function<GlobalConfiguration, EmbeddedCacheManager>(){

            @Override
            public EmbeddedCacheManager apply(GlobalConfiguration global) {
                String defaultCacheName = global.defaultCacheName().orElse(null);
                ConfigurationBuilderHolder holder = new ConfigurationBuilderHolder(global.classLoader(), new GlobalConfigurationBuilder().read(global));
                if (defaultCacheName != null) {
                    holder.newConfigurationBuilder(defaultCacheName);
                }
                DefaultCacheManager manager = new DefaultCacheManager(holder, false);
                if (defaultCacheName != null) {
                    manager.undefineConfiguration(defaultCacheName);
                }
                return manager;
            }
        });
        final ServiceDependency loader = ServiceDependency.on((ServiceName)Services.JBOSS_SERVICE_MODULE_LOADER);
        UnaryOperator<EmbeddedCacheManager> wrapper = new UnaryOperator<EmbeddedCacheManager>(){

            @Override
            public EmbeddedCacheManager apply(EmbeddedCacheManager manager) {
                return new DefaultCacheContainer(manager, (ModuleLoader)loader.get());
            }
        };
        final ServiceValueRegistry<EmbeddedCacheManager> containerRegistry = this.containerRegistry;
        Consumer<EmbeddedCacheManager> start = new Consumer<EmbeddedCacheManager>(){

            @Override
            public void accept(EmbeddedCacheManager manager) {
                manager.start();
                final ClusteredLockManager lockManager = (ClusteredLockManager)GlobalComponentRegistry.componentOf((EmbeddedCacheManager)manager, ClusteredLockManager.class);
                if (lockManager != null) {
                    BasicComponentRegistry registry = (BasicComponentRegistry)GlobalComponentRegistry.componentOf((EmbeddedCacheManager)manager, BasicComponentRegistry.class);
                    registry.replaceComponent(ClusteredLockManager.class.getName(), (Object)new ClusteredLockManager(){

                        public boolean defineLock(final String name) {
                            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                                @Override
                                public Boolean run() {
                                    return lockManager.defineLock(name);
                                }
                            });
                        }

                        public boolean defineLock(final String name, final ClusteredLockConfiguration configuration) {
                            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                                @Override
                                public Boolean run() {
                                    return lockManager.defineLock(name, configuration);
                                }
                            });
                        }

                        public ClusteredLock get(final String name) {
                            return AccessController.doPrivileged(new PrivilegedAction<ClusteredLock>(){

                                @Override
                                public ClusteredLock run() {
                                    return lockManager.get(name);
                                }
                            });
                        }

                        public ClusteredLockConfiguration getConfiguration(String name) {
                            return lockManager.getConfiguration(name);
                        }

                        public boolean isDefined(String name) {
                            return lockManager.isDefined(name);
                        }

                        public CompletableFuture<Boolean> remove(String name) {
                            return lockManager.remove(name);
                        }

                        public CompletableFuture<Boolean> forceRelease(String name) {
                            return lockManager.forceRelease(name);
                        }
                    }, false);
                    registry.rewire();
                }
                containerRegistry.add((Object)ServiceDependency.on((UnaryServiceDescriptor)InfinispanServiceDescriptor.CACHE_CONTAINER, (String)name)).accept(manager);
                manager.addListener(listener);
                InfinispanLogger.ROOT_LOGGER.infof("Started %s cache container", name);
            }
        };
        Consumer<EmbeddedCacheManager> stop = new Consumer<EmbeddedCacheManager>(){

            @Override
            public void accept(EmbeddedCacheManager manager) {
                manager.removeListener(listener);
                containerRegistry.remove((Object)ServiceDependency.on((UnaryServiceDescriptor)InfinispanServiceDescriptor.CACHE_CONTAINER, (String)name));
                manager.stop();
                InfinispanLogger.ROOT_LOGGER.infof("Stopped %s cache container", name);
            }
        };
        ServiceName targetName = CAPABILITY.getCapabilityServiceName(context.getCurrentAddress());
        BinderServiceInstaller binderInstaller = new BinderServiceInstaller(InfinispanCacheContainerBindingFactory.EMBEDDED.apply(name), targetName);
        CapabilityServiceInstaller.Builder builder = CapabilityServiceInstaller.builder(CAPABILITY, (Function)wrapper, (Supplier)container);
        for (String alias : aliases) {
            builder.provides(ServiceNameFactory.resolveServiceName((UnaryServiceDescriptor)InfinispanServiceDescriptor.CACHE_CONTAINER, (String)alias));
            binderInstaller.withAlias(InfinispanCacheContainerBindingFactory.EMBEDDED.apply(alias));
        }
        CapabilityServiceInstaller installer = (CapabilityServiceInstaller)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)builder.blocking()).requires(List.of(container, loader))).onStart((Consumer)start)).onStop((Consumer)stop)).startWhen(Installer.StartWhen.AVAILABLE)).build();
        return ResourceServiceInstaller.combine((ResourceServiceInstaller[])new ResourceServiceInstaller[]{installer, binderInstaller});
    }

    @Listener
    static class CacheLifecycleListener {
        private final String containerName;
        private final ServiceValueRegistry<Cache<?, ?>> registry;
        private final Registrar<String> registrar;
        private final Map<String, Registration> registrations = new ConcurrentHashMap<String, Registration>();

        CacheLifecycleListener(String containerName, ServiceValueRegistry<Cache<?, ?>> registry, Registrar<String> registrar) {
            this.containerName = containerName;
            this.registry = registry;
            this.registrar = registrar;
        }

        @CacheStarted
        public CompletionStage<Void> cacheStarted(CacheStartedEvent event) {
            String cacheName = event.getCacheName();
            BinaryServiceConfiguration configuration = BinaryServiceConfiguration.of((String)this.containerName, (String)cacheName);
            InfinispanLogger.ROOT_LOGGER.started(configuration);
            this.registrations.put(cacheName, this.registrar.register((Object)cacheName));
            Consumer captor = this.registry.add((Object)configuration.getServiceDependency(InfinispanServiceDescriptor.CACHE));
            EmbeddedCacheManager container = event.getCacheManager();
            BlockingManager blocking = (BlockingManager)GlobalComponentRegistry.componentOf((EmbeddedCacheManager)container, BlockingManager.class);
            blocking.asExecutor(event.getCacheName()).execute(() -> captor.accept(container.getCache(cacheName)));
            return CompletableFuture.completedStage(null);
        }

        @CacheStopped
        public CompletionStage<Void> cacheStopped(CacheStoppedEvent event) {
            String cacheName = event.getCacheName();
            BinaryServiceConfiguration configuration = BinaryServiceConfiguration.of((String)this.containerName, (String)cacheName);
            this.registry.remove((Object)configuration.getServiceDependency(InfinispanServiceDescriptor.CACHE));
            try (Registration registration = this.registrations.remove(cacheName);){
                InfinispanLogger.ROOT_LOGGER.stopped(configuration);
            }
            return CompletableFuture.completedStage(null);
        }
    }
}

