/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.Locale;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.Codec30;
import org.infinispan.client.hotrod.impl.protocol.Codec31;
import org.infinispan.client.hotrod.impl.protocol.Codec40;
import org.infinispan.client.hotrod.impl.protocol.Codec41;

public final class ProtocolVersion
extends Enum<ProtocolVersion> {
    public static final /* enum */ ProtocolVersion PROTOCOL_VERSION_30 = new ProtocolVersion(3, 0, new Codec30());
    public static final /* enum */ ProtocolVersion PROTOCOL_VERSION_31 = new ProtocolVersion(3, 1, new Codec31());
    public static final /* enum */ ProtocolVersion PROTOCOL_VERSION_40 = new ProtocolVersion(4, 0, new Codec40());
    public static final /* enum */ ProtocolVersion PROTOCOL_VERSION_41 = new ProtocolVersion(4, 1, new Codec41());
    public static final /* enum */ ProtocolVersion PROTOCOL_VERSION_AUTO = new ProtocolVersion(4, 1, "AUTO", new Codec41());
    private static final ProtocolVersion[] VERSIONS;
    public static final ProtocolVersion DEFAULT_PROTOCOL_VERSION;
    public static final ProtocolVersion HIGHEST_PROTOCOL_VERSION;
    public static final ProtocolVersion SAFE_HANDSHAKE_PROTOCOL_VERSION;
    private final String textVersion;
    private final int version;
    private final Codec codec;
    private static final /* synthetic */ ProtocolVersion[] $VALUES;

    public static ProtocolVersion[] values() {
        return (ProtocolVersion[])$VALUES.clone();
    }

    public static ProtocolVersion valueOf(String name) {
        return Enum.valueOf(ProtocolVersion.class, name);
    }

    private ProtocolVersion(int major, int minor, Codec codec) {
        this(major, minor, String.format(Locale.ROOT, "%d.%d", major, minor), codec);
    }

    private ProtocolVersion(int major, int minor, String name, Codec codec) {
        assert (minor < 10);
        this.textVersion = name;
        this.version = major * 10 + minor;
        this.codec = codec;
    }

    public String toString() {
        return this.textVersion;
    }

    public int getVersion() {
        return this.version;
    }

    public Codec getCodec() {
        return this.codec;
    }

    public static ProtocolVersion parseVersion(String version) {
        if ("AUTO".equalsIgnoreCase(version)) {
            return PROTOCOL_VERSION_AUTO;
        }
        for (ProtocolVersion v : VERSIONS) {
            if (!v.textVersion.equals(version)) continue;
            return v;
        }
        throw new IllegalArgumentException("Illegal version " + version);
    }

    public static ProtocolVersion getBestVersion(int version) {
        for (int i = VERSIONS.length - 2; i >= 0; --i) {
            if (version < ProtocolVersion.VERSIONS[i].version) continue;
            return VERSIONS[i];
        }
        throw new IllegalArgumentException("Illegal version " + version);
    }

    public ProtocolVersion choose(ProtocolVersion serverVersion) {
        if (serverVersion == null) {
            return this;
        }
        return serverVersion.compareTo(this) >= 0 ? this : serverVersion;
    }

    private static /* synthetic */ ProtocolVersion[] $values() {
        return new ProtocolVersion[]{PROTOCOL_VERSION_30, PROTOCOL_VERSION_31, PROTOCOL_VERSION_40, PROTOCOL_VERSION_41, PROTOCOL_VERSION_AUTO};
    }

    static {
        $VALUES = ProtocolVersion.$values();
        VERSIONS = ProtocolVersion.values();
        DEFAULT_PROTOCOL_VERSION = PROTOCOL_VERSION_AUTO;
        HIGHEST_PROTOCOL_VERSION = VERSIONS[VERSIONS.length - 2];
        SAFE_HANDSHAKE_PROTOCOL_VERSION = PROTOCOL_VERSION_31;
    }
}

