/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import org.infinispan.api.Experimental;
import org.infinispan.api.configuration.CacheConfiguration;
import org.infinispan.api.sync.SyncCache;
import org.infinispan.api.sync.SyncCaches;
import org.infinispan.client.hotrod.HotRod;
import org.infinispan.client.hotrod.HotRodSyncCache;
import org.infinispan.client.hotrod.impl.InternalRemoteCache;

@Experimental
final class HotRodSyncCaches
implements SyncCaches {
    private final HotRod hotrod;

    HotRodSyncCaches(HotRod hotrod) {
        this.hotrod = hotrod;
    }

    public <K, V> SyncCache<K, V> get(String name) {
        InternalRemoteCache<K, V> cache = this.getCache(name);
        return new HotRodSyncCache<K, V>(this.hotrod, cache);
    }

    public <K, V> SyncCache<K, V> create(String name, CacheConfiguration cacheConfiguration) {
        this.hotrod.cacheManager.getConfiguration().addRemoteCache(name, builder -> builder.configuration(cacheConfiguration.toString()));
        return this.get(name);
    }

    public <K, V> SyncCache<K, V> create(String name, String template) {
        this.hotrod.cacheManager.getConfiguration().addRemoteCache(name, builder -> builder.templateName(template));
        return this.get(name);
    }

    public void remove(String name) {
        this.hotrod.cacheManager.administration().removeCache(name);
    }

    public Iterable<String> names() {
        return this.hotrod.cacheManager.getCacheNames();
    }

    public void createTemplate(String name, CacheConfiguration cacheConfiguration) {
        throw new UnsupportedOperationException();
    }

    public void removeTemplate(String name) {
        throw new UnsupportedOperationException();
    }

    public Iterable<String> templateNames() {
        throw new UnsupportedOperationException();
    }

    private <K, V> InternalRemoteCache<K, V> getCache(String name) {
        return (InternalRemoteCache)this.hotrod.cacheManager.getCache(name);
    }
}

