/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.disposables.Disposable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Flow;
import java.util.stream.Collectors;
import org.infinispan.api.Experimental;
import org.infinispan.api.async.AsyncCacheEntryProcessor;
import org.infinispan.api.common.CacheEntry;
import org.infinispan.api.common.CacheEntryVersion;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.api.common.CacheWriteOptions;
import org.infinispan.api.common.CloseableIterable;
import org.infinispan.api.common.CloseableIterator;
import org.infinispan.api.common.MutableCacheEntry;
import org.infinispan.api.common.process.CacheEntryProcessorContext;
import org.infinispan.api.common.process.CacheEntryProcessorResult;
import org.infinispan.api.common.process.CacheProcessorOptions;
import org.infinispan.api.configuration.CacheConfiguration;
import org.infinispan.api.sync.SyncCache;
import org.infinispan.api.sync.SyncCacheEntryProcessor;
import org.infinispan.api.sync.SyncContainer;
import org.infinispan.api.sync.SyncQuery;
import org.infinispan.api.sync.SyncStreamingCache;
import org.infinispan.api.sync.events.cache.SyncCacheEntryListener;
import org.infinispan.client.hotrod.HotRod;
import org.infinispan.client.hotrod.HotRodSyncQuery;
import org.infinispan.client.hotrod.HotRodSyncStreamingCache;
import org.infinispan.client.hotrod.impl.InternalRemoteCache;
import org.infinispan.client.hotrod.impl.Util;
import org.reactivestreams.FlowAdapters;
import org.reactivestreams.Publisher;

@Experimental
final class HotRodSyncCache<K, V>
implements SyncCache<K, V> {
    private final HotRod hotrod;
    private final InternalRemoteCache<K, V> remoteCache;

    HotRodSyncCache(HotRod hotrod, InternalRemoteCache<K, V> remoteCache) {
        this.hotrod = hotrod;
        this.remoteCache = remoteCache;
    }

    private <E> E blockingGet(Single<E> single) {
        return (E)single.blockingGet();
    }

    public String name() {
        return this.remoteCache.getName();
    }

    public CacheConfiguration configuration() {
        return null;
    }

    public SyncContainer container() {
        return this.hotrod.sync();
    }

    public CacheEntry<K, V> getEntry(K key, CacheOptions options) {
        return Util.await(this.remoteCache.getEntry(key, options));
    }

    public CacheEntry<K, V> put(K key, V value, CacheWriteOptions options) {
        return Util.await(this.remoteCache.put(key, value, options));
    }

    public void set(K key, V value, CacheWriteOptions options) {
        Util.await(this.remoteCache.set(key, value, options));
    }

    public CacheEntry<K, V> putIfAbsent(K key, V value, CacheWriteOptions options) {
        return Util.await(this.remoteCache.putIfAbsent(key, value, options));
    }

    public boolean setIfAbsent(K key, V value, CacheWriteOptions options) {
        return Util.await(this.remoteCache.setIfAbsent(key, value, options));
    }

    public boolean replace(K key, V value, CacheEntryVersion version, CacheWriteOptions options) {
        return Util.await(this.remoteCache.replace(key, value, version, options));
    }

    public CacheEntry<K, V> getOrReplaceEntry(K key, V value, CacheEntryVersion version, CacheWriteOptions options) {
        return Util.await(this.remoteCache.getOrReplaceEntry(key, value, version, options));
    }

    public boolean remove(K key, CacheOptions options) {
        return Util.await(this.remoteCache.remove(key, options));
    }

    public boolean remove(K key, CacheEntryVersion version, CacheOptions options) {
        return Util.await(this.remoteCache.remove(key, version, options));
    }

    public CacheEntry<K, V> getAndRemove(K key, CacheOptions options) {
        return Util.await(this.remoteCache.getAndRemove(key, options));
    }

    public CloseableIterable<K> keys(CacheOptions options) {
        return () -> HotRodSyncCache.toCloseableIterator(this.remoteCache.keys(options), 64);
    }

    public CloseableIterable<CacheEntry<K, V>> entries(CacheOptions options) {
        return () -> HotRodSyncCache.toCloseableIterator(this.remoteCache.entries(options), 64);
    }

    private static <E> CloseableIterator<E> toCloseableIterator(Flow.Publisher<E> flow, int fetchSize) {
        Flowable flowable = Flowable.fromPublisher((Publisher)FlowAdapters.toPublisher(flow));
        Iterable iterable = flowable.blockingIterable(fetchSize);
        final Iterator iterator = iterable.iterator();
        return new CloseableIterator<E>(){

            public void close() {
                ((Disposable)iterator).dispose();
            }

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public E next() {
                return iterator.next();
            }
        };
    }

    public void putAll(Map<K, V> entries, CacheWriteOptions options) {
        Util.await(this.remoteCache.putAll(entries, options));
    }

    public Map<K, V> getAll(Set<K> keys, CacheOptions options) {
        return (Map)this.blockingGet(Flowable.fromPublisher((Publisher)FlowAdapters.toPublisher(this.remoteCache.getAll(keys, options))).collect(Collectors.toMap(CacheEntry::key, CacheEntry::value)));
    }

    public Map<K, V> getAll(CacheOptions options, K[] keys) {
        return (Map)this.blockingGet(Flowable.fromPublisher((Publisher)FlowAdapters.toPublisher(this.remoteCache.getAll(options, keys))).collect(Collectors.toMap(CacheEntry::key, CacheEntry::value)));
    }

    public Set<K> removeAll(Set<K> keys, CacheWriteOptions options) {
        return (Set)this.blockingGet(Flowable.fromPublisher((Publisher)FlowAdapters.toPublisher(this.remoteCache.removeAll(keys, options))).collect(Collectors.toSet()));
    }

    public Map<K, CacheEntry<K, V>> getAndRemoveAll(Set<K> keys, CacheWriteOptions options) {
        return (Map)this.blockingGet(Flowable.fromPublisher((Publisher)FlowAdapters.toPublisher(this.remoteCache.getAndRemoveAll(keys, options))).collect(Collectors.toMap(CacheEntry::key, ce -> ce)));
    }

    public long estimateSize(CacheOptions options) {
        return Util.await(this.remoteCache.estimateSize(options));
    }

    public void clear(CacheOptions options) {
        Util.await(this.remoteCache.clear(options));
    }

    public <R> SyncQuery<K, V, R> query(String query, CacheOptions options) {
        return new HotRodSyncQuery();
    }

    public AutoCloseable listen(SyncCacheEntryListener<K, V> listener) {
        throw new UnsupportedOperationException();
    }

    public <T> Set<CacheEntryProcessorResult<K, T>> process(Set<K> keys, SyncCacheEntryProcessor<K, V, T> processor, CacheProcessorOptions options) {
        Flow.Publisher<CacheEntryProcessorResult<K, T>> flowPublisher = this.remoteCache.process(keys, new SyncToAsyncEntryProcessor<K, V, T>(processor), (CacheOptions)options);
        return (Set)this.blockingGet(Flowable.fromPublisher((Publisher)FlowAdapters.toPublisher(flowPublisher)).collect(Collectors.toSet()));
    }

    public <T> Set<CacheEntryProcessorResult<K, T>> processAll(SyncCacheEntryProcessor<K, V, T> processor, CacheProcessorOptions options) {
        Flow.Publisher<CacheEntryProcessorResult<K, T>> flowPublisher = this.remoteCache.processAll(new SyncToAsyncEntryProcessor<K, V, T>(processor), options);
        return (Set)this.blockingGet(Flowable.fromPublisher((Publisher)FlowAdapters.toPublisher(flowPublisher)).collect(Collectors.toSet()));
    }

    public SyncStreamingCache<K> streaming() {
        return new HotRodSyncStreamingCache();
    }

    private record SyncToAsyncEntryProcessor<K, V, T>(SyncCacheEntryProcessor<K, V, T> processor) implements AsyncCacheEntryProcessor<K, V, T>
    {
        public Flow.Publisher<CacheEntryProcessorResult<K, T>> process(Flow.Publisher<MutableCacheEntry<K, V>> entries, CacheEntryProcessorContext context) {
            Flowable flowable = Flowable.fromPublisher((Publisher)FlowAdapters.toPublisher(entries)).map(e -> {
                try {
                    return CacheEntryProcessorResult.onResult((Object)e.key(), (Object)this.processor.process(e, context));
                }
                catch (Throwable t) {
                    return CacheEntryProcessorResult.onError((Object)e.key(), (Throwable)t);
                }
            });
            return FlowAdapters.toFlowPublisher((Publisher)flowable);
        }
    }
}

