/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.amqp.converters;

import io.smallrye.reactive.messaging.MessageConverter;
import io.smallrye.reactive.messaging.amqp.IncomingAmqpMetadata;
import io.smallrye.reactive.messaging.providers.helpers.TypeUtils;
import io.vertx.amqp.AmqpMessage;
import jakarta.enterprise.context.ApplicationScoped;
import java.lang.reflect.Type;
import org.eclipse.microprofile.reactive.messaging.Message;

@ApplicationScoped
public class AmqpMessageConverter
implements MessageConverter {
    public boolean canConvert(Message<?> in, Type target) {
        return in.getMetadata(IncomingAmqpMetadata.class).isPresent() && TypeUtils.isAssignable((Type)target, AmqpMessage.class);
    }

    public Message<?> convert(Message<?> in, Type target) {
        IncomingAmqpMetadata metadata = (IncomingAmqpMetadata)in.getMetadata(IncomingAmqpMetadata.class).orElseThrow(() -> new IllegalStateException("No AMQP 1.0 metadata"));
        return in.withPayload((Object)metadata.getMessage());
    }
}

