/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.user;

import java.util.Map;
import org.wildfly.clustering.cache.CacheProperties;
import org.wildfly.clustering.session.cache.user.CompositeUser;
import org.wildfly.clustering.session.cache.user.UserContextFactory;
import org.wildfly.clustering.session.cache.user.UserFactory;
import org.wildfly.clustering.session.cache.user.UserSessionsFactory;
import org.wildfly.clustering.session.user.User;
import org.wildfly.clustering.session.user.UserSessions;

public class CompositeUserFactory<CV, C, T, SV, D, S>
implements UserFactory<CV, C, T, SV, D, S> {
    private final UserContextFactory<CV, C, T> contextFactory;
    private final UserSessionsFactory<SV, D, S> sessionsFactory;
    private final CacheProperties properties;

    public CompositeUserFactory(UserContextFactory<CV, C, T> contextFactory, UserSessionsFactory<SV, D, S> sessionsFactory, CacheProperties properties) {
        this.contextFactory = contextFactory;
        this.sessionsFactory = sessionsFactory;
        this.properties = properties;
    }

    @Override
    public User<C, T, D, S> createUser(String id, Map.Entry<CV, SV> entry) {
        CV contextValue = entry.getKey();
        SV sessionsValue = entry.getValue();
        if (contextValue == null || sessionsValue == null) {
            return null;
        }
        Map.Entry<C, T> context = this.contextFactory.createUserContext(contextValue);
        UserSessions<D, S> sessions = this.sessionsFactory.createUserSessions(id, sessionsValue);
        return new CompositeUser<C, T, D, S>(id, context, sessions, this);
    }

    @Override
    public UserContextFactory<CV, C, T> getUserContextFactory() {
        return this.contextFactory;
    }

    @Override
    public UserSessionsFactory<SV, D, S> getUserSessionsFactory() {
        return this.sessionsFactory;
    }

    @Override
    public CacheProperties getCacheProperties() {
        return this.properties;
    }
}

