/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.impl.table;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.persistence.jdbc.common.DatabaseType;
import org.infinispan.persistence.jdbc.common.configuration.AbstractJdbcStoreConfiguration;
import org.infinispan.persistence.jdbc.common.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.common.logging.Log;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfiguration;
import org.infinispan.persistence.jdbc.impl.table.DB2TableManager;
import org.infinispan.persistence.jdbc.impl.table.DbMetaData;
import org.infinispan.persistence.jdbc.impl.table.GenericTableManager;
import org.infinispan.persistence.jdbc.impl.table.H2TableManager;
import org.infinispan.persistence.jdbc.impl.table.MyTableOperations;
import org.infinispan.persistence.jdbc.impl.table.OracleTableManager;
import org.infinispan.persistence.jdbc.impl.table.PostgresTableManager;
import org.infinispan.persistence.jdbc.impl.table.SQLiteTableManager;
import org.infinispan.persistence.jdbc.impl.table.SqlServerTableManager;
import org.infinispan.persistence.jdbc.impl.table.SybaseTableManager;
import org.infinispan.persistence.jdbc.impl.table.TableManager;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.util.logging.LogFactory;

public class TableManagerFactory {
    private static final Log log = (Log)LogFactory.getLog(TableManagerFactory.class, Log.class);
    public static final String UPSERT_DISABLED = "infinispan.jdbc.upsert.disabled";
    public static final String INDEXING_DISABLED = "infinispan.jdbc.indexing.disabled";

    public static <K, V> TableManager<K, V> getManager(InitializationContext ctx, ConnectionFactory connectionFactory, JdbcStringBasedStoreConfiguration config, String cacheName) {
        DbMetaData metaData = TableManagerFactory.getDbMetaData(connectionFactory, config);
        return TableManagerFactory.getManager(metaData, ctx, connectionFactory, config, cacheName);
    }

    public static <K, V> TableManager<K, V> getManager(DbMetaData metaData, InitializationContext ctx, ConnectionFactory connectionFactory, JdbcStringBasedStoreConfiguration config, String cacheName) {
        switch (metaData.getType()) {
            case DB2: 
            case DB2_390: {
                return new DB2TableManager(ctx, connectionFactory, config, metaData, cacheName);
            }
            case H2: {
                return new H2TableManager(ctx, connectionFactory, config, metaData, cacheName);
            }
            case MARIA_DB: 
            case MYSQL: {
                return new MyTableOperations(ctx, connectionFactory, config, metaData, cacheName);
            }
            case ORACLE: {
                return new OracleTableManager(ctx, connectionFactory, config, metaData, cacheName);
            }
            case POSTGRES: {
                return new PostgresTableManager(ctx, connectionFactory, config, metaData, cacheName);
            }
            case SQLITE: {
                return new SQLiteTableManager(ctx, connectionFactory, config, metaData, cacheName);
            }
            case SYBASE: {
                return new SybaseTableManager(ctx, connectionFactory, config, metaData, cacheName);
            }
            case SQL_SERVER: {
                return new SqlServerTableManager(ctx, connectionFactory, config, metaData, cacheName);
            }
        }
        return new GenericTableManager(ctx, connectionFactory, config, metaData, cacheName);
    }

    private static DbMetaData getDbMetaData(ConnectionFactory connectionFactory, JdbcStringBasedStoreConfiguration config) {
        return TableManagerFactory.getDbMetaData(connectionFactory, config, !config.segmented());
    }

    public static DbMetaData getDbMetaData(ConnectionFactory connectionFactory, JdbcStringBasedStoreConfiguration config, boolean segmentedDisabled) {
        DatabaseType databaseType = config.dialect();
        Connection connection = null;
        try {
            connection = connectionFactory.getConnection();
            DatabaseMetaData metaData = connection.getMetaData();
            int majorVersion = metaData.getDatabaseMajorVersion();
            int minorVersion = metaData.getDatabaseMinorVersion();
            int maxTableName = metaData.getMaxTableNameLength();
            String version = majorVersion + "." + minorVersion;
            if (log.isDebugEnabled()) {
                log.debugf("Database version reported as '%s'.", (Object)version);
            }
            if (databaseType == null) {
                databaseType = TableManagerFactory.determineDatabaseType(metaData);
                if (databaseType == null) {
                    throw new CacheConfigurationException("Unable to detect database dialect from JDBC driver name or connection metadata.  Please provide this manually using the 'dialect' property in your configuration.  Supported database dialect strings are " + Arrays.toString(DatabaseType.values()));
                }
                log.debugf("Guessing database dialect as '%s'.  If this is incorrect, please specify the correct dialect using the 'dialect' attribute in your configuration.  Supported database dialect strings are %s", (Object)databaseType, (Object)Arrays.toString(DatabaseType.values()));
            }
            DbMetaData dbMetaData = new DbMetaData(databaseType, majorVersion, minorVersion, maxTableName, TableManagerFactory.isPropertyDisabled(config, UPSERT_DISABLED), TableManagerFactory.isPropertyDisabled(config, INDEXING_DISABLED), segmentedDisabled);
            return dbMetaData;
        }
        catch (SQLException e) {
            throw new CacheException((Throwable)e);
        }
        finally {
            connectionFactory.releaseConnection(connection);
        }
    }

    private static DatabaseType determineDatabaseType(DatabaseMetaData metaData) throws SQLException {
        String dbProduct = metaData.getDatabaseProductName();
        DatabaseType databaseType = DatabaseType.guessDialect((String)dbProduct);
        if (databaseType != null) {
            return databaseType;
        }
        String dbDriver = metaData.getDriverName();
        log.debugf("Unable to detect database dialect using produce name %s.  Attempting to guess on driver name %s.", (Object)dbProduct, (Object)dbDriver);
        return DatabaseType.guessDialect((String)dbDriver);
    }

    private static boolean isPropertyDisabled(AbstractJdbcStoreConfiguration config, String propertyName) {
        String property = config.properties().getProperty(propertyName);
        return property != null && Boolean.parseBoolean(property);
    }
}

