/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.Arrays;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.threads.EnhancedQueueExecutorService;
import org.jboss.as.threads.PoolAttributeDefinitions;
import org.jboss.as.threads.ThreadPoolMetricsHandler;
import org.jboss.as.threads.ThreadsLogger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;

public class QueuelessThreadPoolMetricsHandler
extends ThreadPoolMetricsHandler {
    public static final List<AttributeDefinition> METRICS = Arrays.asList(PoolAttributeDefinitions.CURRENT_THREAD_COUNT, PoolAttributeDefinitions.LARGEST_THREAD_COUNT, PoolAttributeDefinitions.REJECTED_COUNT, PoolAttributeDefinitions.QUEUE_SIZE);

    public QueuelessThreadPoolMetricsHandler(RuntimeCapability<Void> capability, ServiceName serviceBaseName) {
        super(METRICS, capability, serviceBaseName);
    }

    @Override
    protected void setResult(OperationContext context, String attributeName, Service<?> service) {
        EnhancedQueueExecutorService pool = (EnhancedQueueExecutorService)service;
        switch (attributeName) {
            case "current-thread-count": {
                context.getResult().set(pool.getCurrentThreadCount());
                break;
            }
            case "largest-thread-count": {
                context.getResult().set(pool.getLargestThreadCount());
                break;
            }
            case "rejected-count": {
                context.getResult().set(pool.getRejectedCount());
                break;
            }
            case "queue-size": {
                context.getResult().set(pool.getRejectedCount());
                break;
            }
            default: {
                throw ThreadsLogger.ROOT_LOGGER.unsupportedQueuelessThreadPoolMetric(attributeName);
            }
        }
    }
}

