/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.host.controller.descriptions.HostResolver;
import org.jboss.as.host.controller.operations.DomainControllerWriteAttributeHandler;
import org.jboss.as.host.controller.operations.HostAddHandler;
import org.jboss.dmr.ModelNode;

public abstract class LocalDomainControllerAddHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "write-local-domain-controller";
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("write-local-domain-controller", HostResolver.getResolver("host")).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.DOMAIN_CONTROLLER).setDeprecated(ModelVersion.create((int)5, (int)0, (int)0)).build();

    public static LocalDomainControllerAddHandler getInstance(DomainControllerWriteAttributeHandler writeAttributeHandler) {
        return new RealLocalDomainControllerAddHandler(writeAttributeHandler);
    }

    public static LocalDomainControllerAddHandler getTestInstance() {
        return new TestLocalDomainControllerAddHandler();
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        boolean hostAdd;
        Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        ModelNode model = resource.getModel();
        ModelNode dc = model.get("domain-controller");
        dc.get("local").setEmptyObject();
        if (dc.has("remote")) {
            dc.remove("remote");
        }
        boolean bl = hostAdd = context.getAttachment(HostAddHandler.HOST_ADD_AFTER_BOOT) == null ? false : (Boolean)context.getAttachment(HostAddHandler.HOST_ADD_AFTER_BOOT);
        if (context.isBooting() || hostAdd) {
            this.initializeDomain(hostAdd ? context.getCurrentAddress().getLastElement().getValue() : null);
        } else {
            context.reloadRequired();
        }
        context.completeStep(new OperationContext.RollbackHandler(){

            public void handleRollback(OperationContext context, ModelNode operation) {
                if (!context.isBooting()) {
                    context.revertReloadRequired();
                }
            }
        });
    }

    abstract void initializeDomain(String var1);

    private static class RealLocalDomainControllerAddHandler
    extends LocalDomainControllerAddHandler {
        private final DomainControllerWriteAttributeHandler writeAttributeHandler;

        RealLocalDomainControllerAddHandler(DomainControllerWriteAttributeHandler writeAttributeHandler) {
            this.writeAttributeHandler = writeAttributeHandler;
        }

        @Override
        void initializeDomain(String hostName) {
            this.writeAttributeHandler.initializeLocalDomain(hostName);
        }
    }

    private static class TestLocalDomainControllerAddHandler
    extends LocalDomainControllerAddHandler {
        private TestLocalDomainControllerAddHandler() {
        }

        @Override
        void initializeDomain(String hostName) {
        }
    }
}

