/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonObject;
import java.util.function.Function;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.AbstractElasticsearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionRequestContext;
import org.hibernate.search.engine.search.common.NamedValues;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.dsl.ProjectionFinalStep;

final class ElasticsearchWithParametersProjection<P>
extends AbstractElasticsearchProjection<P> {
    private final ElasticsearchSearchIndexScope<?> scope;
    private final Function<? super NamedValues, ? extends ProjectionFinalStep<P>> projectionCreator;

    public ElasticsearchWithParametersProjection(ElasticsearchSearchIndexScope<?> scope, Function<? super NamedValues, ? extends ProjectionFinalStep<P>> projectionCreator) {
        super(scope);
        this.scope = scope;
        this.projectionCreator = projectionCreator;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[projectionCreator=" + String.valueOf(this.projectionCreator) + "]";
    }

    @Override
    public ElasticsearchSearchProjection.Extractor<?, P> request(JsonObject requestBody, ProjectionRequestContext context) {
        SearchProjection delegate = this.projectionCreator.apply((NamedValues)context.queryParameters()).toProjection();
        return ElasticsearchSearchProjection.from(this.scope, delegate).request(requestBody, context);
    }
}

