/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.embedded.listener;

import java.util.concurrent.CompletionStage;
import org.infinispan.Cache;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.util.concurrent.BlockingManager;
import org.wildfly.clustering.cache.infinispan.embedded.listener.NonBlockingCacheEventListener;
import org.wildfly.clustering.function.BiConsumer;
import org.wildfly.clustering.function.Consumer;

public class BlockingCacheEventListener<K, V>
extends NonBlockingCacheEventListener<K, V> {
    private final BlockingManager blocking;
    private final String name;

    public BlockingCacheEventListener(Cache<K, V> cache, java.util.function.Consumer<K> consumer) {
        this(cache, (java.util.function.BiConsumer<K, V>)BiConsumer.of(consumer, (java.util.function.Consumer)Consumer.empty()), consumer.getClass());
    }

    public BlockingCacheEventListener(Cache<K, V> cache, java.util.function.BiConsumer<K, V> consumer) {
        this(cache, consumer, consumer.getClass());
    }

    private BlockingCacheEventListener(Cache<K, V> cache, java.util.function.BiConsumer<K, V> consumer, Class<?> consumerClass) {
        super(consumer);
        this.blocking = (BlockingManager)GlobalComponentRegistry.componentOf((EmbeddedCacheManager)cache.getCacheManager(), BlockingManager.class);
        this.name = consumerClass.getName();
    }

    @Override
    public CompletionStage<Void> apply(CacheEntryEvent<K, V> event) {
        return this.blocking.runBlocking(() -> super.accept(event), (Object)this.name);
    }

    @Override
    public void accept(CacheEntryEvent<K, V> event) {
        this.blocking.asExecutor(this.name).execute(() -> super.accept(event));
    }
}

