/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.global;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.global.FilteredData;
import org.jboss.as.controller.operations.global.GlobalOperationAttributes;
import org.jboss.as.controller.operations.global.GlobalOperationHandlers;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ReadChildrenNamesHandler
implements OperationStepHandler {
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("read-children-names", ControllerResolver.getResolver("global")).setParameters(GlobalOperationAttributes.CHILD_TYPE, GlobalOperationAttributes.INCLUDE_SINGLETONS).setReadOnly().setReplyType(ModelType.LIST).setReplyValueType(ModelType.STRING).build();
    public static final OperationStepHandler INSTANCE = new ReadChildrenNamesHandler();

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        String childType = GlobalOperationAttributes.CHILD_TYPE.resolveModelAttribute(context, operation).asString();
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS, false);
        ImmutableManagementResourceRegistration registry = context.getResourceRegistration();
        Map<String, Set<String>> childAddresses = GlobalOperationHandlers.getChildAddresses(context, address, registry, resource, childType);
        Set<String> childNames = childAddresses.get(childType);
        if (childNames == null) {
            throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.unknownChildType(childType));
        }
        boolean singletons = GlobalOperationAttributes.INCLUDE_SINGLETONS.resolveModelAttribute(context, operation).asBoolean(false);
        if (singletons && this.isSingletonResource(registry, childType) && !registry.isRuntimeOnly()) {
            Set<PathElement> childTypes = registry.getChildAddresses(PathAddress.EMPTY_ADDRESS);
            for (PathElement child : childTypes) {
                if (!childType.equals(child.getKey()) || this.isEmptyRuntimeResource(context, registry, PathAddress.pathAddress(child))) continue;
                childNames.add(child.getValue());
            }
        }
        childNames = new TreeSet<String>(childNames);
        ModelNode result = context.getResult();
        result.setEmptyList();
        PathAddress childAddress = address.append(PathElement.pathElement(childType));
        ModelNode op = Util.createEmptyOperation("read-resource", childAddress);
        op.get("operation-headers").set(operation.get("operation-headers"));
        ModelNode opAddr = op.get("address");
        ModelNode childProperty = opAddr.require(address.size());
        EnumSet<Action.ActionEffect> actionEffects = EnumSet.of(Action.ActionEffect.ADDRESS);
        FilteredData fd = null;
        for (String childName : childNames) {
            childProperty.set(childType, new ModelNode(childName));
            if (context.authorize(op, actionEffects).getDecision() == AuthorizationResult.Decision.PERMIT) {
                result.add(childName);
                continue;
            }
            if (fd == null) {
                fd = new FilteredData(address);
            }
            fd.addAccessRestrictedResource(childAddress);
        }
        if (fd != null) {
            context.getResponseHeaders().get("access-control").set(fd.toModelNode());
        }
    }

    private boolean isSingletonResource(ImmutableManagementResourceRegistration registry, String key) {
        return registry.getSubModel(PathAddress.pathAddress(PathElement.pathElement(key))) == null;
    }

    private boolean isEmptyRuntimeResource(OperationContext context, ImmutableManagementResourceRegistration registry, PathAddress child) {
        if (registry.getSubModel(child).isRuntimeOnly()) {
            try {
                context.readResource(child);
            }
            catch (Resource.NoSuchResourceException ex) {
                return true;
            }
        }
        return false;
    }
}

