/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.capability;

import java.util.function.Function;
import org.jboss.as.controller.PathAddress;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum UnaryCapabilityNameResolver implements Function<PathAddress, String[]>
{
    DEFAULT{

        @Override
        public String[] apply(PathAddress address) {
            return new String[]{address.getLastElement().getValue()};
        }
    }
    ,
    PARENT{

        @Override
        public String[] apply(PathAddress address) {
            return new String[]{address.getParent().getLastElement().getValue()};
        }
    }
    ,
    GRANDPARENT{

        @Override
        public String[] apply(PathAddress address) {
            return new String[]{address.getParent().getParent().getLastElement().getValue()};
        }
    }
    ,
    GREATGRANDPARENT{

        @Override
        public String[] apply(PathAddress address) {
            return new String[]{address.getParent().getParent().getParent().getLastElement().getValue()};
        }
    }
    ,
    LOCAL{

        @Override
        public String[] apply(PathAddress address) {
            return new String[]{"local"};
        }
    };

}

