/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.ResourceBundle;
import org.jboss.as.controller.Feature;
import org.jboss.as.controller.descriptions.DefaultNotificationDescriptionProvider;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.version.Stability;
import org.jboss.dmr.ModelNode;

public class NotificationDefinition
implements Feature {
    private final String type;
    private final ResourceDescriptionResolver resolver;
    private final DataValueDescriptor dataValueDescriptor;
    private final Stability stability;

    private NotificationDefinition(Builder builder) {
        this.type = builder.type;
        this.resolver = builder.resolver;
        this.dataValueDescriptor = builder.dataValueDescriptor;
        this.stability = builder.stability;
    }

    @Override
    public Stability getStability() {
        return this.stability;
    }

    public String getType() {
        return this.type;
    }

    public DescriptionProvider getDescriptionProvider() {
        return new DefaultNotificationDescriptionProvider(this, this.resolver, this.dataValueDescriptor);
    }

    public static class Builder {
        private final String type;
        private final ResourceDescriptionResolver resolver;
        private DataValueDescriptor dataValueDescriptor = DataValueDescriptor.NO_DATA;
        private Stability stability = Stability.DEFAULT;

        private Builder(String type, ResourceDescriptionResolver resolver) {
            this.type = type;
            this.resolver = resolver;
        }

        public static Builder create(String type, ResourceDescriptionResolver resolver) {
            return new Builder(type, resolver);
        }

        public Builder setDataValueDescriptor(DataValueDescriptor dataValueDescriptor) {
            this.dataValueDescriptor = dataValueDescriptor;
            return this;
        }

        public Builder setStability(Stability stability) {
            this.stability = stability;
            return this;
        }

        public NotificationDefinition build() {
            return new NotificationDefinition(this);
        }
    }

    public static interface DataValueDescriptor {
        public static final DataValueDescriptor NO_DATA = new DataValueDescriptor(){

            @Override
            public ModelNode describe(ResourceBundle bundle) {
                return null;
            }
        };

        public ModelNode describe(ResourceBundle var1);
    }
}

