/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful.cache.distributable;

import jakarta.ejb.ConcurrentAccessTimeoutException;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBean;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBeanCache;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBeanInstance;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBeanInstanceFactory;
import org.jboss.as.ejb3.component.stateful.cache.distributable.DistributableStatefulSessionBean;
import org.jboss.as.ejb3.component.stateful.cache.distributable.DistributableStatefulSessionBeanCacheConfiguration;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.ejb.client.Affinity;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.batch.SuspendedBatch;
import org.wildfly.clustering.context.Context;
import org.wildfly.clustering.ejb.bean.Bean;
import org.wildfly.clustering.ejb.bean.BeanInstance;
import org.wildfly.clustering.ejb.bean.BeanManager;

public class DistributableStatefulSessionBeanCache<K, V extends StatefulSessionBeanInstance<K>>
implements StatefulSessionBeanCache<K, V> {
    private static final Object UNSET = Boolean.TRUE;
    private final BeanManager<K, V> manager;
    private final StatefulSessionBeanInstanceFactory<V> factory;

    public DistributableStatefulSessionBeanCache(DistributableStatefulSessionBeanCacheConfiguration<K, V> configuration) {
        this.manager = configuration.getBeanManager();
        this.factory = configuration.getInstanceFactory();
    }

    public boolean isStarted() {
        return this.manager.isStarted();
    }

    public void start() {
        this.manager.start();
    }

    public void stop() {
        this.manager.stop();
    }

    public Affinity getStrongAffinity() {
        return this.manager.getStrongAffinity();
    }

    public Affinity getWeakAffinity(K id) {
        return this.manager.getWeakAffinity(id);
    }

    @Override
    public StatefulSessionBean<K, V> createStatefulSessionBean() {
        boolean newGroup;
        boolean bl = newGroup = CURRENT_GROUP.get() == null;
        if (newGroup) {
            CURRENT_GROUP.set(UNSET);
        }
        try {
            DistributableStatefulSessionBean distributableStatefulSessionBean;
            block15: {
                SuspendedBatch suspended = ((Batch)this.manager.getBatchFactory().get()).suspend();
                Context batch = suspended.resumeWithContext();
                try {
                    StatefulSessionBeanInstance instance = (StatefulSessionBeanInstance)this.factory.createInstance();
                    Object id = instance.getId();
                    if (CURRENT_GROUP.get() == UNSET) {
                        CURRENT_GROUP.set(id);
                    }
                    Bean bean = this.manager.createBean((BeanInstance)instance, CURRENT_GROUP.get());
                    distributableStatefulSessionBean = new DistributableStatefulSessionBean(bean, suspended);
                    if (batch == null) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (batch != null) {
                            try {
                                batch.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Error | RuntimeException e) {
                        this.rollback(() -> ((SuspendedBatch)suspended).resume());
                        throw e;
                    }
                }
                batch.close();
            }
            return distributableStatefulSessionBean;
        }
        finally {
            if (newGroup) {
                CURRENT_GROUP.remove();
            }
        }
    }

    @Override
    public StatefulSessionBean<K, V> findStatefulSessionBean(K id) {
        StatefulSessionBean statefulSessionBean;
        block9: {
            SuspendedBatch suspended = ((Batch)this.manager.getBatchFactory().get()).suspend();
            Context batch = suspended.resumeWithContext();
            try {
                Bean bean = this.manager.findBean(id);
                StatefulSessionBean statefulSessionBean2 = statefulSessionBean = bean != null ? new DistributableStatefulSessionBean(bean, suspended) : this.rollback((Supplier<Batch>)batch);
                if (batch == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (batch != null) {
                        try {
                            batch.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (TimeoutException e) {
                    throw new ConcurrentAccessTimeoutException(e.getMessage());
                }
                catch (Error | RuntimeException e) {
                    this.rollback(() -> ((SuspendedBatch)suspended).resume());
                    throw e;
                }
            }
            batch.close();
        }
        return statefulSessionBean;
    }

    private StatefulSessionBean<K, V> rollback(Supplier<Batch> batchProvider) {
        try (Batch batch = batchProvider.get();){
            batch.discard();
        }
        catch (Error | RuntimeException e) {
            EjbLogger.EJB3_INVOCATION_LOGGER.warn(e.getLocalizedMessage(), e);
        }
        return null;
    }

    public int getActiveCount() {
        return this.manager.getActiveCount();
    }

    public int getPassiveCount() {
        return this.manager.getPassiveCount();
    }

    @Override
    public Supplier<K> getIdentifierFactory() {
        return this.manager.getIdentifierFactory();
    }

    @Override
    public boolean isRemotable(Throwable throwable) {
        return this.manager.isRemotable(throwable);
    }
}

