/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorExecutionContext;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.Values;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.IndexReaderMetadataResolver;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.projection.impl.AbstractLuceneProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionRequestContext;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionTransformContext;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneByMappedTypeProjection<P>
extends AbstractLuceneProjection<P> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Map<String, LuceneSearchProjection<? extends P>> inners;

    public LuceneByMappedTypeProjection(LuceneSearchIndexScope<?> scope, Map<String, LuceneSearchProjection<? extends P>> inners) {
        super(scope);
        this.inners = inners;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[inners=" + String.valueOf(this.inners) + "]";
    }

    @Override
    public LuceneSearchProjection.Extractor<?, P> request(ProjectionRequestContext context) {
        HashMap innerExtractors = new HashMap();
        for (Map.Entry<String, LuceneSearchProjection<P>> entry : this.inners.entrySet()) {
            innerExtractors.put(entry.getKey(), entry.getValue().request(context));
        }
        return new ByMappedTypeExtractor(innerExtractors);
    }

    private final class ByMappedTypeExtractor
    implements LuceneSearchProjection.Extractor<DelegateAndExtractedValue<?, P>, P> {
        private final Map<String, LuceneSearchProjection.Extractor<?, ? extends P>> inners;

        private ByMappedTypeExtractor(Map<String, LuceneSearchProjection.Extractor<?, ? extends P>> inners) {
            this.inners = inners;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[inners=" + String.valueOf(this.inners) + "]";
        }

        @Override
        public Values<DelegateAndExtractedValue<?, P>> values(ProjectionExtractContext context) {
            HashMap innerValues = new HashMap();
            for (Map.Entry entry : this.inners.entrySet()) {
                innerValues.put(entry.getKey(), new ValuesWrapper(entry.getValue(), context));
            }
            return new ByMappedTypeValues(context.collectorExecutionContext(), innerValues);
        }

        @Override
        public P transform(LoadingResult<?> loadingResult, DelegateAndExtractedValue<?, P> extracted, ProjectionTransformContext context) {
            return extracted.transform(loadingResult, context);
        }
    }

    private static final class DelegateAndExtractedValue<E, P> {
        private final LuceneSearchProjection.Extractor<E, ? extends P> delegate;
        private final E extractedValue;

        private DelegateAndExtractedValue(LuceneSearchProjection.Extractor<E, ? extends P> delegate, E extractedValue) {
            this.delegate = delegate;
            this.extractedValue = extractedValue;
        }

        P transform(LoadingResult<?> loadingResult, ProjectionTransformContext context) {
            return this.delegate.transform(loadingResult, this.extractedValue, context);
        }
    }

    private static final class ByMappedTypeValues<P>
    implements Values<DelegateAndExtractedValue<?, P>> {
        private final IndexReaderMetadataResolver metadataResolver;
        private final Map<String, Values<? extends DelegateAndExtractedValue<?, P>>> inners;
        private Values<? extends DelegateAndExtractedValue<?, P>> currentLeafInner;

        public ByMappedTypeValues(CollectorExecutionContext executionContext, Map<String, Values<? extends DelegateAndExtractedValue<?, P>>> inners) {
            this.metadataResolver = executionContext.getMetadataResolver();
            this.inners = inners;
        }

        @Override
        public void context(LeafReaderContext context) throws IOException {
            String typeName = this.metadataResolver.resolveMappedTypeName(context);
            this.currentLeafInner = this.inners.get(typeName);
            if (this.currentLeafInner == null) {
                throw log.unexpectedMappedTypeNameForByMappedTypeProjection(typeName, this.inners.keySet());
            }
            this.currentLeafInner.context(context);
        }

        @Override
        public DelegateAndExtractedValue<?, P> get(int doc) throws IOException {
            return this.currentLeafInner.get(doc);
        }
    }

    private static final class ValuesWrapper<E, P>
    implements Values<DelegateAndExtractedValue<E, P>> {
        private final LuceneSearchProjection.Extractor<E, ? extends P> extractor;
        private final Values<E> values;

        private ValuesWrapper(LuceneSearchProjection.Extractor<E, ? extends P> extractor, ProjectionExtractContext context) {
            this.extractor = extractor;
            this.values = extractor.values(context);
        }

        @Override
        public void context(LeafReaderContext context) throws IOException {
            this.values.context(context);
        }

        @Override
        public DelegateAndExtractedValue<E, P> get(int doc) throws IOException {
            return new DelegateAndExtractedValue<E, P>(this.extractor, this.values.get(doc));
        }
    }
}

