/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.unstable.api.annotation.classpath.runtime.bytecode;

import java.io.IOException;
import org.wildfly.unstable.api.annotation.classpath.index.RuntimeIndex;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.ReusableStreams;

class ClassInformation {
    private static final RuntimeIndex.ByteArrayKey[] EMPTY_BYTE_ARRAY_KEY_ARRAY = new RuntimeIndex.ByteArrayKey[0];
    private final int[] tags;
    private final byte[] constPoolBytes;
    private final int[] offsets;
    private final int thisClassPosition;
    private final int superClassPosition;
    private final int[] interfacePositions;
    private final RuntimeIndex.ByteArrayKey[] byteArrayKeys;
    private final int constantPoolSize;
    private RuntimeIndex.ByteArrayKey scannedClassKey;
    private String scannedClassName;

    ClassInformation(int[] tags, byte[] constPoolBytes, int[] offsets, int thisClassPosition, int superClassPosition, int[] interfacePositions, int constantPoolSize) {
        this.tags = tags;
        this.constPoolBytes = constPoolBytes;
        this.offsets = offsets;
        this.thisClassPosition = thisClassPosition;
        this.superClassPosition = superClassPosition;
        this.interfacePositions = interfacePositions;
        this.byteArrayKeys = new RuntimeIndex.ByteArrayKey[tags.length];
        this.constantPoolSize = constantPoolSize;
    }

    RuntimeIndex.ByteArrayKey getClassNameFromRefInfo(int constantPoolPosition) {
        int index = constantPoolPosition - 1;
        int classPosition = this.readUnsignedShortByConstantPoolOffset(this.offsets[index]);
        return this.getClassNameFromClassInfo(classPosition);
    }

    RuntimeIndex.ByteArrayKey getNameFromRefInfo(int constantPoolPosition) {
        int nameAndTypeInfoPosition = this.getNameAndTypeInfoPositionFromRefInfo(constantPoolPosition);
        int offset = this.offsets[nameAndTypeInfoPosition - 1];
        int refNamePosition = this.readUnsignedShortByConstantPoolOffset(offset);
        return this.getKeyFromUtfInfo(refNamePosition);
    }

    RuntimeIndex.ByteArrayKey getDescriptorFromRefInfo(int constantPoolPosition) {
        int nameAndTypeInfoPosition = this.getNameAndTypeInfoPositionFromRefInfo(constantPoolPosition);
        int offset = this.offsets[nameAndTypeInfoPosition - 1];
        int refNamePosition = this.readUnsignedShortByConstantPoolOffset(offset + 2);
        return this.getKeyFromUtfInfo(refNamePosition);
    }

    RuntimeIndex.ByteArrayKey getClassNameFromClassInfo(int constantPoolPosition) {
        int index = constantPoolPosition - 1;
        RuntimeIndex.ByteArrayKey key = this.byteArrayKeys[index];
        if (key == null) {
            int utfInfoPosition = this.readUnsignedShortByConstantPoolOffset(this.offsets[index]);
            this.byteArrayKeys[index] = key = this.getKeyFromUtfInfo(utfInfoPosition);
        }
        return key;
    }

    RuntimeIndex.ByteArrayKey getScannedClass() {
        if (this.scannedClassKey == null) {
            this.scannedClassKey = this.getClassNameFromClassInfo(this.thisClassPosition);
        }
        return this.scannedClassKey;
    }

    String getScannedClassName(ReusableStreams reusableStreams) throws IOException {
        if (this.scannedClassName == null) {
            RuntimeIndex.ByteArrayKey key = this.getClassNameFromClassInfo(this.thisClassPosition);
            this.scannedClassName = RuntimeIndex.convertClassNameToDotFormat(key.convertBytesToString(reusableStreams));
        }
        return this.scannedClassName;
    }

    RuntimeIndex.ByteArrayKey getSuperClass() {
        if (this.superClassPosition == 0) {
            return null;
        }
        return this.getClassNameFromClassInfo(this.superClassPosition);
    }

    RuntimeIndex.ByteArrayKey[] getInterfaces() {
        if (this.interfacePositions.length == 0) {
            return EMPTY_BYTE_ARRAY_KEY_ARRAY;
        }
        RuntimeIndex.ByteArrayKey[] keys = new RuntimeIndex.ByteArrayKey[this.interfacePositions.length];
        for (int i = 0; i < this.interfacePositions.length; ++i) {
            keys[i] = this.getClassNameFromClassInfo(this.interfacePositions[i]);
        }
        return keys;
    }

    private int getNameAndTypeInfoPositionFromRefInfo(int constantPoolPosition) {
        int index = constantPoolPosition - 1;
        int refInfoOffset = this.offsets[index];
        int position = this.readUnsignedShortByConstantPoolOffset(refInfoOffset + 2);
        return position;
    }

    private RuntimeIndex.ByteArrayKey getKeyFromUtfInfo(int constantPoolPosition) {
        int index = constantPoolPosition - 1;
        RuntimeIndex.ByteArrayKey key = this.byteArrayKeys[index];
        if (key == null) {
            int offset = this.offsets[index];
            int nextOffset = index == this.offsets.length - 1 ? this.constantPoolSize : this.offsets[index + 1];
            int length = nextOffset - offset;
            this.byteArrayKeys[index] = key = RuntimeIndex.ByteArrayKey.create(this.constPoolBytes, offset, length);
        }
        return key;
    }

    private int readUnsignedShortByConstantPoolOffset(int offset) {
        int ch2;
        int ch1 = this.readByteAsUnsignedIntByConstantPoolOffset(offset);
        if ((ch1 | (ch2 = this.readByteAsUnsignedIntByConstantPoolOffset(offset + 1))) < 0) {
            throw new IllegalStateException();
        }
        return (ch1 << 8) + ch2;
    }

    private int readByteAsUnsignedIntByConstantPoolOffset(int offset) {
        return this.constPoolBytes[offset] & 0xFF;
    }

    public int[] getTags() {
        return this.tags;
    }
}

