/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client.impl;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.as.controller.client.MessageSeverity;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.as.controller.client.impl.InputStreamEntry;
import org.jboss.as.controller.client.impl.OperationResponseProxy;
import org.jboss.as.controller.client.logging.ControllerClientLogger;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.AbstractManagementRequest;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementChannelAssociation;
import org.jboss.as.protocol.mgmt.ManagementProtocolHeader;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.protocol.mgmt.ManagementRequestHandler;
import org.jboss.as.protocol.mgmt.ManagementRequestHandlerFactory;
import org.jboss.as.protocol.mgmt.ManagementRequestHeader;
import org.jboss.as.protocol.mgmt.ManagementResponseHeader;
import org.jboss.as.protocol.mgmt.ProtocolUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.threads.AsyncFuture;

public abstract class AbstractModelControllerClient
implements ModelControllerClient,
ManagementRequestHandlerFactory {
    private static final ManagementRequestHandler<ModelNode, OperationExecutionContext> MESSAGE_HANDLER = new HandleReportRequestHandler();
    private static final ManagementRequestHandler<ModelNode, OperationExecutionContext> GET_INPUT_STREAM = new ReadAttachmentInputStreamRequestHandler();
    private static final OperationMessageHandler NO_OP_HANDLER = OperationMessageHandler.DISCARD;

    protected abstract ManagementChannelAssociation getChannelAssociation();

    @Override
    public ModelNode execute(ModelNode operation) throws IOException {
        return AbstractModelControllerClient.responseNodeOnly(this.executeForResult(OperationExecutionContext.create(operation)));
    }

    @Override
    public ModelNode execute(Operation operation) throws IOException {
        return AbstractModelControllerClient.responseNodeOnly(this.executeForResult(OperationExecutionContext.create(operation)));
    }

    @Override
    public ModelNode execute(ModelNode operation, OperationMessageHandler messageHandler) throws IOException {
        return AbstractModelControllerClient.responseNodeOnly(this.executeForResult(OperationExecutionContext.create(operation, messageHandler)));
    }

    @Override
    public ModelNode execute(Operation operation, OperationMessageHandler messageHandler) throws IOException {
        return AbstractModelControllerClient.responseNodeOnly(this.executeForResult(OperationExecutionContext.create(operation, messageHandler)));
    }

    @Override
    public OperationResponse executeOperation(Operation operation, OperationMessageHandler messageHandler) throws IOException {
        return this.executeForResult(OperationExecutionContext.create(operation, messageHandler));
    }

    @Override
    public CompletableFuture<ModelNode> executeAsync(ModelNode operation, OperationMessageHandler messageHandler) {
        try {
            return this.execute(OperationExecutionContext.create(operation, messageHandler), AbstractModelControllerClient::responseNodeOnlyWitRuntimeException);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletableFuture<ModelNode> executeAsync(Operation operation, OperationMessageHandler messageHandler) {
        try {
            return this.execute(OperationExecutionContext.create(operation, messageHandler), AbstractModelControllerClient::responseNodeOnlyWitRuntimeException);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletableFuture<OperationResponse> executeOperationAsync(Operation operation, OperationMessageHandler messageHandler) {
        try {
            return this.execute(OperationExecutionContext.create(operation, messageHandler), (OperationResponse opResponse) -> opResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ManagementRequestHandler<?, ?> resolveHandler(ManagementRequestHandlerFactory.RequestHandlerChain handlers, ManagementRequestHeader header) {
        byte operationType = header.getOperationId();
        if (operationType == 72) {
            return MESSAGE_HANDLER;
        }
        if (operationType == 76) {
            return GET_INPUT_STREAM;
        }
        return handlers.resolveNext();
    }

    private OperationResponse executeForResult(OperationExecutionContext executionContext) throws IOException {
        try {
            return this.execute(executionContext, (OperationResponse opResponse) -> opResponse).get();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private static ModelNode responseNodeOnly(OperationResponse or) throws IOException {
        ModelNode result = or.getResponseNode();
        or.close();
        return result;
    }

    private static ModelNode responseNodeOnlyWitRuntimeException(OperationResponse or) {
        try {
            return AbstractModelControllerClient.responseNodeOnly(or);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private <T> CompletableFuture<T> execute(final OperationExecutionContext executionContext, Function<OperationResponse, T> transformer) throws IOException {
        return this.executeRequest((ManagementRequest<OperationResponse, OperationExecutionContext>)new AbstractManagementRequest<OperationResponse, OperationExecutionContext>(){

            public byte getOperationType() {
                return 69;
            }

            protected void sendRequest(ActiveOperation.ResultHandler<OperationResponse> resultHandler, ManagementRequestContext<OperationExecutionContext> context, FlushableDataOutput output) throws IOException {
                List<InputStream> streams = executionContext.operation.getInputStreams();
                ModelNode operation = executionContext.operation.getOperation();
                int inputStreamLength = 0;
                if (streams != null) {
                    inputStreamLength = streams.size();
                }
                output.write(97);
                operation.writeExternal((DataOutput)output);
                output.write(101);
                output.writeInt(inputStreamLength);
            }

            public void handleRequest(DataInput input, ActiveOperation.ResultHandler<OperationResponse> resultHandler, ManagementRequestContext<OperationExecutionContext> context) throws IOException {
                ProtocolUtils.expectHeader((DataInput)input, (int)100);
                ModelNode node = new ModelNode();
                node.readExternal(input);
                resultHandler.done((Object)AbstractModelControllerClient.this.getOperationResponse(node, context.getOperationId()));
                ProtocolUtils.expectHeader((DataInput)input, (int)36);
            }
        }, executionContext, transformer);
    }

    <T> CompletableFuture<T> executeRequest(ManagementRequest<OperationResponse, OperationExecutionContext> request, OperationExecutionContext attachment, Function<OperationResponse, T> transformer) throws IOException {
        ActiveOperation activeOperation = this.getChannelAssociation().executeRequest(request, (Object)attachment, (ActiveOperation.CompletedCallback)attachment);
        Consumer<Boolean> asyncCancelTask = interruptionAllowed -> this.executeCancelAsyncRequest(activeOperation);
        return activeOperation.getCompletableFuture(transformer, asyncCancelTask);
    }

    private void executeCancelAsyncRequest(ActiveOperation<?, ?> activeOperation) {
        if (activeOperation.getResult().getStatus() == AsyncFuture.Status.WAITING) {
            Integer operationId = activeOperation.getOperationId();
            try {
                this.getChannelAssociation().executeRequest(operationId, (ManagementRequest)new CancelAsyncRequest());
            }
            catch (Exception e) {
                AsyncFuture.Status status = activeOperation.getResult().getStatus();
                if (status == AsyncFuture.Status.WAITING) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
                ControllerClientLogger.ROOT_LOGGER.debugf(e, "Executing CancelAsyncRequest for operation %s failed but the operation reached status %s, so the failure is being ignored", operationId, status);
            }
        }
    }

    static List<InputStreamEntry> createStreamEntries(Operation operation) {
        List<InputStream> streams = operation.getInputStreams();
        if (streams.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<InputStreamEntry> entries = new ArrayList<InputStreamEntry>();
        boolean autoClose = operation.isAutoCloseStreams();
        for (InputStream stream : streams) {
            if (stream instanceof InputStreamEntry) {
                entries.add((InputStreamEntry)((Object)stream));
                continue;
            }
            entries.add(new InputStreamEntry.InMemoryEntry(stream, autoClose));
        }
        return entries;
    }

    private OperationResponse getOperationResponse(ModelNode simpleResponse, int batchId) {
        ModelNode streamHeader;
        ModelNode modelNode = streamHeader = simpleResponse.hasDefined("response-headers") && simpleResponse.get("response-headers").hasDefined("attached-streams") ? simpleResponse.get(new String[]{"response-headers", "attached-streams"}) : null;
        if (streamHeader != null && streamHeader.asInt() > 0) {
            return OperationResponseProxy.create(simpleResponse, this.getChannelAssociation(), batchId, streamHeader);
        }
        return OperationResponse.Factory.createSimple(simpleResponse);
    }

    static class OperationExecutionContext
    implements ActiveOperation.CompletedCallback<OperationResponse> {
        private final Operation operation;
        private final OperationMessageHandler handler;
        private final List<InputStreamEntry> streams;

        OperationExecutionContext(Operation operation, OperationMessageHandler handler) {
            this.operation = operation;
            this.handler = handler != null ? handler : NO_OP_HANDLER;
            this.streams = AbstractModelControllerClient.createStreamEntries(operation);
        }

        OperationMessageHandler getOperationMessageHandler() {
            return this.handler;
        }

        InputStreamEntry getStream(int index) {
            InputStreamEntry entry = this.streams.get(index);
            if (entry == null) {
                return InputStreamEntry.EMPTY;
            }
            return entry;
        }

        public void completed(OperationResponse result) {
            this.closeAttachments();
        }

        public void failed(Exception e) {
            this.closeAttachments();
        }

        public void cancelled() {
            this.closeAttachments();
        }

        private void closeAttachments() {
            for (InputStreamEntry entry : this.streams) {
                StreamUtils.safeClose((Closeable)entry);
            }
            if (this.operation.isAutoCloseStreams()) {
                StreamUtils.safeClose((Closeable)this.operation);
            }
        }

        static OperationExecutionContext create(ModelNode operation) {
            return OperationExecutionContext.create(new OperationBuilder(operation).build(), NO_OP_HANDLER);
        }

        static OperationExecutionContext create(Operation operation) {
            return OperationExecutionContext.create(operation, NO_OP_HANDLER);
        }

        static OperationExecutionContext create(ModelNode operation, OperationMessageHandler handler) {
            return OperationExecutionContext.create(new OperationBuilder(operation).build(), handler);
        }

        static OperationExecutionContext create(Operation operation, OperationMessageHandler handler) {
            return new OperationExecutionContext(operation, handler);
        }
    }

    private static class CancelAsyncRequest
    extends AbstractManagementRequest<OperationResponse, OperationExecutionContext> {
        private CancelAsyncRequest() {
        }

        public byte getOperationType() {
            return 77;
        }

        protected void sendRequest(ActiveOperation.ResultHandler<OperationResponse> resultHandler, ManagementRequestContext<OperationExecutionContext> context, FlushableDataOutput output) {
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<OperationResponse> resultHandler, ManagementRequestContext<OperationExecutionContext> context) {
            resultHandler.cancel();
        }
    }

    private static class HandleReportRequestHandler
    implements ManagementRequestHandler<ModelNode, OperationExecutionContext> {
        private HandleReportRequestHandler() {
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<ModelNode> resultHandler, ManagementRequestContext<OperationExecutionContext> context) throws IOException {
            ProtocolUtils.expectHeader((DataInput)input, (int)98);
            MessageSeverity severity = Enum.valueOf(MessageSeverity.class, input.readUTF());
            ProtocolUtils.expectHeader((DataInput)input, (int)99);
            String message = input.readUTF();
            ProtocolUtils.expectHeader((DataInput)input, (int)21);
            OperationExecutionContext requestContext = (OperationExecutionContext)context.getAttachment();
            OperationMessageHandler handler = requestContext.getOperationMessageHandler();
            handler.handleReport(severity, message);
        }
    }

    private static class ReadAttachmentInputStreamRequestHandler
    implements ManagementRequestHandler<ModelNode, OperationExecutionContext> {
        private ReadAttachmentInputStreamRequestHandler() {
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<ModelNode> resultHandler, ManagementRequestContext<OperationExecutionContext> context) throws IOException {
            ProtocolUtils.expectHeader((DataInput)input, (int)102);
            final int index = input.readInt();
            context.executeAsync((ManagementRequestContext.AsyncTask)new ManagementRequestContext.AsyncTask<OperationExecutionContext>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void execute(ManagementRequestContext<OperationExecutionContext> taskContext) throws Exception {
                    InputStreamEntry entry;
                    OperationExecutionContext exec = (OperationExecutionContext)taskContext.getAttachment();
                    ManagementRequestHeader header = (ManagementRequestHeader)taskContext.getRequestHeader();
                    ManagementResponseHeader response = new ManagementResponseHeader(header.getVersion(), header.getRequestId(), null);
                    InputStreamEntry inputStreamEntry = entry = exec.getStream(index);
                    synchronized (inputStreamEntry) {
                        int size = entry.initialize();
                        FlushableDataOutput output = taskContext.writeMessage((ManagementProtocolHeader)response);
                        try {
                            output.writeByte(103);
                            output.writeInt(size);
                            output.writeByte(104);
                            entry.copyStream((DataOutput)output);
                            output.writeByte(36);
                            output.close();
                        }
                        finally {
                            StreamUtils.safeClose((Closeable)output);
                        }
                    }
                }
            });
        }
    }
}

