/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.subsystem.resource.operation;

import java.util.Optional;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.global.ReadAttributeHandler;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.wildfly.subsystem.resource.AttributeTranslation;

public class ReadAttributeTranslationOperationStepHandler
implements OperationStepHandler {
    private final AttributeTranslation translation;

    public ReadAttributeTranslationOperationStepHandler(AttributeTranslation translation) {
        this.translation = translation;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ImmutableManagementResourceRegistration registration;
        PathAddress currentAddress = context.getCurrentAddress();
        PathAddress targetAddress = (PathAddress)this.translation.getPathAddressTranslator().apply(currentAddress);
        AttributeDefinition targetAttribute = this.translation.getTargetAttribute();
        ModelNode targetOperation = Util.getReadAttributeOperation((PathAddress)targetAddress, (String)targetAttribute.getName());
        if (operation.hasDefined("include-defaults")) {
            targetOperation.get("include-defaults").set(operation.get("include-defaults"));
        }
        ImmutableManagementResourceRegistration immutableManagementResourceRegistration = registration = currentAddress == targetAddress ? context.getResourceRegistration() : context.getRootResourceRegistration().getSubModel(targetAddress);
        if (registration == null) {
            throw new OperationFailedException(ControllerLogger.MGMT_OP_LOGGER.noSuchResourceType(targetAddress));
        }
        OperationStepHandler readAttributeHandler = Optional.ofNullable(registration.getAttributeAccess(PathAddress.EMPTY_ADDRESS, targetAttribute.getName()).getReadHandler()).orElse(ReadAttributeHandler.RESOLVE_INSTANCE);
        ReadTranslatedAttributeOperationStepHandler readTranslatedAttributeHandler = new ReadTranslatedAttributeOperationStepHandler(readAttributeHandler, this.translation.getReadAttributeOperationTranslator());
        if (targetAddress == currentAddress) {
            readTranslatedAttributeHandler.execute(context, targetOperation);
        } else {
            if (registration.isRuntimeOnly()) {
                try {
                    context.readResourceFromRoot(targetAddress, false);
                }
                catch (Resource.NoSuchResourceException ignore) {
                    return;
                }
            }
            context.addStep(targetOperation, (OperationStepHandler)readTranslatedAttributeHandler, context.getCurrentStage(), true);
        }
    }

    private static class ReadTranslatedAttributeOperationStepHandler
    implements OperationStepHandler {
        private final OperationStepHandler readHandler;
        private final AttributeTranslation.AttributeValueTranslator translator;

        ReadTranslatedAttributeOperationStepHandler(OperationStepHandler readHandler, AttributeTranslation.AttributeValueTranslator translator) {
            this.readHandler = readHandler;
            this.translator = translator;
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            this.readHandler.execute(context, operation);
            ModelNode result = context.getResult();
            result.set(this.translator.translate(context, result));
        }
    }
}

