/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.context;

import java.util.function.Consumer;
import org.wildfly.clustering.function.Supplier;

public interface Context<T>
extends Supplier<T>,
AutoCloseable {
    public static final Context<?> EMPTY = new Context<Object>(){

        public Object get() {
            return null;
        }

        @Override
        public void close() {
        }
    };

    @Override
    public void close();

    public static <T> Context<T> empty() {
        return EMPTY;
    }

    public static <T> Context<T> of(final T value, final Consumer<T> closeAction) {
        return new Context<T>(){

            public T get() {
                return value;
            }

            @Override
            public void close() {
                closeAction.accept(value);
            }
        };
    }
}

