/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web;

import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.capability.UnaryCapabilityNameResolver;
import org.jboss.as.controller.descriptions.ParentResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.web.service.routing.RouteLocatorProvider;
import org.wildfly.clustering.web.service.routing.RoutingProvider;
import org.wildfly.extension.clustering.web.AffinityResourceRegistration;
import org.wildfly.extension.clustering.web.DistributableWebSubsystemResourceDefinitionRegistrar;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.ChildResourceDefinitionRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrationContext;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.ResourceModelResolver;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public abstract class AffinityResourceDefinitionRegistrar
implements ChildResourceDefinitionRegistrar,
ResourceServiceConfigurator,
ResourceModelResolver<Supplier<RouteLocatorProvider>>,
UnaryOperator<ResourceDescriptor.Builder> {
    private final ResourceRegistration registration;
    private final RuntimeCapability<Void> capability;

    AffinityResourceDefinitionRegistrar(ResourceRegistration registration) {
        this(registration, UnaryOperator.identity());
    }

    AffinityResourceDefinitionRegistrar(ResourceRegistration registration, NullaryServiceDescriptor<RoutingProvider> routingProviderRequirement) {
        this(registration, builder -> builder.addRequirements(new NullaryServiceDescriptor[]{routingProviderRequirement}));
    }

    private AffinityResourceDefinitionRegistrar(ResourceRegistration registration, UnaryOperator<RuntimeCapability.Builder<Void>> configurator) {
        this.registration = registration;
        this.capability = ((RuntimeCapability.Builder)configurator.apply(RuntimeCapability.Builder.of((UnaryServiceDescriptor)RouteLocatorProvider.SERVICE_DESCRIPTOR))).setAllowMultipleRegistrations(true).setDynamicNameMapper((Function)UnaryCapabilityNameResolver.PARENT).build();
    }

    @Override
    public ResourceDescriptor.Builder apply(ResourceDescriptor.Builder builder) {
        return (ResourceDescriptor.Builder)((ResourceDescriptor.Builder)builder.addCapability(this.capability)).withRuntimeHandler(ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this));
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent, ManagementResourceRegistrationContext context) {
        ParentResourceDescriptionResolver resolver = DistributableWebSubsystemResourceDefinitionRegistrar.RESOLVER.createChildResolver(this.registration.getPathElement(), AffinityResourceRegistration.WILDCARD.getPathElement());
        ResourceDescriptor descriptor = this.apply(ResourceDescriptor.builder((ResourceDescriptionResolver)resolver)).build();
        ManagementResourceRegistration registration = parent.registerSubModel(ResourceDefinition.builder((ResourceRegistration)this.registration, (ResourceDescriptionResolver)resolver).build());
        ManagementResourceRegistrar.of((ResourceDescriptor)descriptor).register(registration);
        return registration;
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        return (ResourceServiceInstaller)CapabilityServiceInstaller.builder(this.capability, (Supplier)((Supplier)this.resolve(context, model))).build();
    }
}

