/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.cache.timer;

import java.lang.reflect.Method;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Predicate;
import org.wildfly.clustering.ejb.cache.timer.ImmutableTimerMetaDataEntry;
import org.wildfly.clustering.ejb.cache.timer.TimerMetaDataEntry;
import org.wildfly.clustering.ejb.timer.TimerType;
import org.wildfly.clustering.server.offset.OffsetValue;

public class MutableTimerMetaDataEntry<C>
implements TimerMetaDataEntry<C> {
    private final ImmutableTimerMetaDataEntry<C> entry;
    private final OffsetValue<Duration> lastTimeout;

    public MutableTimerMetaDataEntry(ImmutableTimerMetaDataEntry<C> entry, OffsetValue<Duration> lastTimeout) {
        this.entry = entry;
        this.lastTimeout = lastTimeout;
    }

    @Override
    public TimerType getType() {
        return this.entry.getType();
    }

    @Override
    public C getContext() {
        return this.entry.getContext();
    }

    public Instant getStart() {
        return this.entry.getStart();
    }

    @Override
    public Predicate<Method> getTimeoutMatcher() {
        return this.entry.getTimeoutMatcher();
    }

    @Override
    public Duration getLastTimeout() {
        return (Duration)this.lastTimeout.get();
    }

    @Override
    public void setLastTimeout(Duration timeout) {
        this.lastTimeout.set((Object)timeout);
    }

    @Override
    public Instant apply(Instant instant) {
        return (Instant)this.entry.apply(instant);
    }
}

