/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.subsystem;

import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.ee.subsystem.ConcurrentAttribute;
import org.jboss.as.ee.subsystem.ConcurrentElement;
import org.jboss.as.ee.subsystem.ContextServiceResourceDefinition;
import org.jboss.as.ee.subsystem.ManagedExecutorServiceResourceDefinition;
import org.jboss.as.ee.subsystem.ManagedScheduledExecutorServiceResourceDefinition;
import org.jboss.as.ee.subsystem.ManagedThreadFactoryResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class ConcurrentEESubsystemParser60 {
    private ConcurrentEESubsystemParser60() {
    }

    public static void parseConcurrent(XMLExtendedStreamReader reader, List<ModelNode> operations, PathAddress subsystemPathAddress) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            ConcurrentElement element = ConcurrentElement.forName(reader.getLocalName());
            switch (element) {
                case CONTEXT_SERVICES: {
                    ConcurrentEESubsystemParser60.parseContextServices(reader, operations, subsystemPathAddress);
                    continue block6;
                }
                case MANAGED_THREAD_FACTORIES: {
                    ConcurrentEESubsystemParser60.parseManagedThreadFactories(reader, operations, subsystemPathAddress);
                    continue block6;
                }
                case MANAGED_EXECUTOR_SERVICES: {
                    ConcurrentEESubsystemParser60.parseManagedExecutorServices(reader, operations, subsystemPathAddress);
                    continue block6;
                }
                case MANAGED_SCHEDULED_EXECUTOR_SERVICES: {
                    ConcurrentEESubsystemParser60.parseManagedScheduledExecutorServices(reader, operations, subsystemPathAddress);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static void parseContextServices(XMLExtendedStreamReader reader, List<ModelNode> operations, PathAddress subsystemPathAddress) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        boolean empty = true;
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (ConcurrentElement.forName(reader.getLocalName())) {
                case CONTEXT_SERVICE: {
                    empty = false;
                    ConcurrentEESubsystemParser60.parseContextService(reader, operations, subsystemPathAddress);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (empty) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(ConcurrentElement.CONTEXT_SERVICE));
        }
    }

    static void parseContextService(XMLExtendedStreamReader reader, List<ModelNode> operations, PathAddress subsystemPathAddress) throws XMLStreamException {
        ModelNode addOperation = Util.createAddOperation();
        int count = reader.getAttributeCount();
        String name = null;
        EnumSet<ConcurrentAttribute> required = EnumSet.of(ConcurrentAttribute.NAME, ConcurrentAttribute.JNDI_NAME);
        block5: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            ConcurrentAttribute attribute = ConcurrentAttribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value.trim();
                    continue block5;
                }
                case JNDI_NAME: {
                    ContextServiceResourceDefinition.JNDI_NAME_AD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block5;
                }
                case USE_TRANSACTION_SETUP_PROVIDER: {
                    ContextServiceResourceDefinition.USE_TRANSACTION_SETUP_PROVIDER_AD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        PathAddress address = subsystemPathAddress.append("context-service", name);
        addOperation.get("address").set(address.toModelNode());
        operations.add(addOperation);
    }

    static void parseManagedExecutorServices(XMLExtendedStreamReader reader, List<ModelNode> operations, PathAddress subsystemPathAddress) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        boolean empty = true;
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (ConcurrentElement.forName(reader.getLocalName())) {
                case MANAGED_EXECUTOR_SERVICE: {
                    empty = false;
                    ConcurrentEESubsystemParser60.parseManagedExecutorService(reader, operations, subsystemPathAddress);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (empty) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(ConcurrentElement.MANAGED_EXECUTOR_SERVICE));
        }
    }

    static void parseManagedExecutorService(XMLExtendedStreamReader reader, List<ModelNode> operations, PathAddress subsystemPathAddress) throws XMLStreamException {
        ModelNode addOperation = Util.createAddOperation();
        int count = reader.getAttributeCount();
        String name = null;
        EnumSet<ConcurrentAttribute> required = EnumSet.of(ConcurrentAttribute.NAME, ConcurrentAttribute.JNDI_NAME);
        block15: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            ConcurrentAttribute attribute = ConcurrentAttribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value.trim();
                    continue block15;
                }
                case JNDI_NAME: {
                    ManagedExecutorServiceResourceDefinition.JNDI_NAME_AD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block15;
                }
                case CONTEXT_SERVICE: {
                    ManagedExecutorServiceResourceDefinition.CONTEXT_SERVICE_AD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block15;
                }
                case THREAD_FACTORY: {
                    ManagedExecutorServiceResourceDefinition.THREAD_FACTORY_AD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block15;
                }
                case THREAD_PRIORITY: {
                    ManagedExecutorServiceResourceDefinition.THREAD_PRIORITY_AD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block15;
                }
                case HUNG_TASK_TERMINATION_PERIOD: {
                    ManagedExecutorServiceResourceDefinition.HUNG_TASK_TERMINATION_PERIOD_AD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block15;
                }
                case HUNG_TASK_THRESHOLD: {
                    ManagedExecutorServiceResourceDefinition.HUNG_TASK_THRESHOLD_AD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block15;
                }
                case LONG_RUNNING_TASKS: {
                    ManagedExecutorServiceResourceDefinition.LONG_RUNNING_TASKS_AD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block15;
                }
                case CORE_THREADS: {
                    ManagedExecutorServiceResourceDefinition.CORE_THREADS_AD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block15;
                }
                case MAX_THREADS: {
                    ManagedExecutorServiceResourceDefinition.MAX_THREADS_AD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block15;
                }
                case KEEPALIVE_TIME: {
                    ManagedExecutorServiceResourceDefinition.KEEPALIVE_TIME_AD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block15;
                }
                case QUEUE_LENGTH: {
                    ManagedExecutorServiceResourceDefinition.QUEUE_LENGTH_AD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block15;
                }
                case REJECT_POLICY: {
                    ManagedExecutorServiceResourceDefinition.REJECT_POLICY_AD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block15;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        PathAddress address = subsystemPathAddress.append("managed-executor-service", name);
        addOperation.get("address").set(address.toModelNode());
        operations.add(addOperation);
    }

    static void parseManagedScheduledExecutorServices(XMLExtendedStreamReader reader, List<ModelNode> operations, PathAddress subsystemPathAddress) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        boolean empty = true;
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (ConcurrentElement.forName(reader.getLocalName())) {
                case MANAGED_SCHEDULED_EXECUTOR_SERVICE: {
                    empty = false;
                    ConcurrentEESubsystemParser60.parseManagedScheduledExecutorService(reader, operations, subsystemPathAddress);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (empty) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(ConcurrentElement.MANAGED_SCHEDULED_EXECUTOR_SERVICE));
        }
    }

    static void parseManagedScheduledExecutorService(XMLExtendedStreamReader reader, List<ModelNode> operations, PathAddress subsystemPathAddress) throws XMLStreamException {
        ModelNode addOperation = Util.createAddOperation();
        int count = reader.getAttributeCount();
        String name = null;
        EnumSet<ConcurrentAttribute> required = EnumSet.of(ConcurrentAttribute.NAME, ConcurrentAttribute.JNDI_NAME);
        block13: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            ConcurrentAttribute attribute = ConcurrentAttribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value.trim();
                    continue block13;
                }
                case JNDI_NAME: {
                    ManagedScheduledExecutorServiceResourceDefinition.JNDI_NAME_AD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block13;
                }
                case CONTEXT_SERVICE: {
                    ManagedScheduledExecutorServiceResourceDefinition.CONTEXT_SERVICE_AD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block13;
                }
                case THREAD_FACTORY: {
                    ManagedScheduledExecutorServiceResourceDefinition.THREAD_FACTORY_AD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block13;
                }
                case THREAD_PRIORITY: {
                    ManagedScheduledExecutorServiceResourceDefinition.THREAD_PRIORITY_AD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block13;
                }
                case HUNG_TASK_TERMINATION_PERIOD: {
                    ManagedScheduledExecutorServiceResourceDefinition.HUNG_TASK_TERMINATION_PERIOD_AD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block13;
                }
                case HUNG_TASK_THRESHOLD: {
                    ManagedScheduledExecutorServiceResourceDefinition.HUNG_TASK_THRESHOLD_AD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block13;
                }
                case LONG_RUNNING_TASKS: {
                    ManagedScheduledExecutorServiceResourceDefinition.LONG_RUNNING_TASKS_AD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block13;
                }
                case CORE_THREADS: {
                    ManagedScheduledExecutorServiceResourceDefinition.CORE_THREADS_AD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block13;
                }
                case KEEPALIVE_TIME: {
                    ManagedScheduledExecutorServiceResourceDefinition.KEEPALIVE_TIME_AD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block13;
                }
                case REJECT_POLICY: {
                    ManagedScheduledExecutorServiceResourceDefinition.REJECT_POLICY_AD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block13;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        PathAddress address = subsystemPathAddress.append("managed-scheduled-executor-service", name);
        addOperation.get("address").set(address.toModelNode());
        operations.add(addOperation);
    }

    static void parseManagedThreadFactories(XMLExtendedStreamReader reader, List<ModelNode> operations, PathAddress subsystemPathAddress) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        boolean empty = true;
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (ConcurrentElement.forName(reader.getLocalName())) {
                case MANAGED_THREAD_FACTORY: {
                    empty = false;
                    ConcurrentEESubsystemParser60.parseManagedThreadFactory(reader, operations, subsystemPathAddress);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (empty) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(ConcurrentElement.MANAGED_THREAD_FACTORY));
        }
    }

    static void parseManagedThreadFactory(XMLExtendedStreamReader reader, List<ModelNode> operations, PathAddress subsystemPathAddress) throws XMLStreamException {
        ModelNode addOperation = Util.createAddOperation();
        int count = reader.getAttributeCount();
        String name = null;
        EnumSet<ConcurrentAttribute> required = EnumSet.of(ConcurrentAttribute.NAME, ConcurrentAttribute.JNDI_NAME);
        block6: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            ConcurrentAttribute attribute = ConcurrentAttribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value.trim();
                    continue block6;
                }
                case JNDI_NAME: {
                    ManagedThreadFactoryResourceDefinition.JNDI_NAME_AD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block6;
                }
                case CONTEXT_SERVICE: {
                    ManagedThreadFactoryResourceDefinition.CONTEXT_SERVICE_AD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block6;
                }
                case PRIORITY: {
                    ManagedThreadFactoryResourceDefinition.PRIORITY_AD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        PathAddress address = subsystemPathAddress.append("managed-thread-factory", name);
        addOperation.get("address").set(address.toModelNode());
        operations.add(addOperation);
    }
}

