/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.client.configuration;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.CXFBusFactory;
import org.apache.cxf.bus.extension.ExtensionManagerBus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.ResourceResolver;
import org.jboss.wsf.stack.cxf.client.ClientBusSelector;
import org.jboss.wsf.stack.cxf.client.ProviderImpl;
import org.jboss.wsf.stack.cxf.client.configuration.BeanCustomizer;
import org.jboss.wsf.stack.cxf.client.configuration.DefaultHTTPConduitFactoryWrapper;
import org.jboss.wsf.stack.cxf.client.configuration.JBossWSConfigurerImpl;
import org.jboss.wsf.stack.cxf.client.configuration.SecurityActions;
import org.jboss.wsf.stack.cxf.client.configuration.SecurityProviderConfig;
import org.jboss.wsf.stack.cxf.client.injection.JBossWSResourceInjectionResolver;

public class JBossWSBusFactory
extends CXFBusFactory {
    private static final Map<ClassLoader, Bus> classLoaderBusses = new WeakHashMap<ClassLoader, Bus>();

    public Bus createBus(Map<Class<?>, Object> extensions, Map<String, Object> properties) {
        if (extensions == null) {
            extensions = new HashMap();
        }
        if (!extensions.containsKey(Configurer.class)) {
            extensions.put(Configurer.class, new JBossWSConfigurerImpl(new BeanCustomizer()));
        }
        ExtensionManagerBus bus = new ExtensionManagerBus(extensions, properties, ProviderImpl.class.getClassLoader());
        JBossWSBusFactory.possiblySetDefaultBus((Bus)bus);
        this.initializeBus((Bus)bus);
        bus.initialize();
        DefaultHTTPConduitFactoryWrapper.install((Bus)bus);
        return bus;
    }

    protected void initializeBus(Bus bus) {
        super.initializeBus(bus);
        ResourceManager resourceManager = (ResourceManager)bus.getExtension(ResourceManager.class);
        resourceManager.addResourceResolver((ResourceResolver)JBossWSResourceInjectionResolver.getInstance());
        SecurityProviderConfig.setup(bus);
        String forceURLConnection = System.getProperty("force.urlconnection.http.conduit");
        Object busForceURLconnection = bus.getProperty("force.urlconnection.http.conduit");
        if (busForceURLconnection == null && forceURLConnection == null | Boolean.parseBoolean(forceURLConnection)) {
            bus.setProperty("force.urlconnection.http.conduit", (Object)true);
        }
    }

    public static Bus getDefaultBus(ClassLoader contextClassLoader) {
        ClassLoader origClassLoader = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(contextClassLoader);
            Bus bus = BusFactory.getDefaultBus();
            return bus;
        }
        finally {
            SecurityActions.setContextClassLoader(origClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bus getClassLoaderDefaultBus(ClassLoader classloader, ClientBusSelector clientBusSelector) {
        Bus classLoaderBus;
        Map<ClassLoader, Bus> map = classLoaderBusses;
        synchronized (map) {
            classLoaderBus = classLoaderBusses.get(classloader);
            if (classLoaderBus == null) {
                classLoaderBus = clientBusSelector.createNewBus();
                ClassLoaderDefaultBusLifeCycleListener listener = new ClassLoaderDefaultBusLifeCycleListener(classLoaderBus);
                ((BusLifeCycleManager)classLoaderBus.getExtension(BusLifeCycleManager.class)).registerLifeCycleListener((BusLifeCycleListener)listener);
                classLoaderBusses.put(classloader, classLoaderBus);
            }
        }
        return classLoaderBus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bus getClassLoaderDefaultBus(ClassLoader classloader) {
        Bus classLoaderBus;
        Map<ClassLoader, Bus> map = classLoaderBusses;
        synchronized (map) {
            classLoaderBus = classLoaderBusses.get(classloader);
            if (classLoaderBus == null) {
                classLoaderBus = new JBossWSBusFactory().createBus();
                ClassLoaderDefaultBusLifeCycleListener listener = new ClassLoaderDefaultBusLifeCycleListener(classLoaderBus);
                ((BusLifeCycleManager)classLoaderBus.getExtension(BusLifeCycleManager.class)).registerLifeCycleListener((BusLifeCycleListener)listener);
                classLoaderBusses.put(classloader, classLoaderBus);
            }
        }
        return classLoaderBus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearDefaultBusForAnyClassLoader(Bus bus) {
        Map<ClassLoader, Bus> map = classLoaderBusses;
        synchronized (map) {
            Iterator<Bus> iterator = classLoaderBusses.values().iterator();
            while (iterator.hasNext()) {
                Bus itBus = iterator.next();
                if (bus != null && itBus != null && !bus.equals(itBus)) continue;
                iterator.remove();
            }
        }
    }

    private static class ClassLoaderDefaultBusLifeCycleListener
    implements BusLifeCycleListener {
        private final Bus bus;

        public ClassLoaderDefaultBusLifeCycleListener(Bus bus) {
            this.bus = bus;
        }

        public void initComplete() {
        }

        public void preShutdown() {
        }

        public void postShutdown() {
            JBossWSBusFactory.clearDefaultBusForAnyClassLoader(this.bus);
        }
    }
}

