/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.services.workmanager;

import java.util.concurrent.Executor;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.security.ElytronSecurityIntegration;
import org.jboss.as.connector.services.workmanager.NamedDistributedWorkManager;
import org.jboss.as.connector.services.workmanager.StatisticsExecutorImpl;
import org.jboss.as.connector.services.workmanager.transport.CommandDispatcherTransport;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.txn.integration.JBossContextXATerminator;
import org.jboss.jca.core.api.workmanager.WorkManager;
import org.jboss.jca.core.spi.transaction.xa.XATerminator;
import org.jboss.jca.core.spi.workmanager.Address;
import org.jboss.jca.core.spi.workmanager.transport.Transport;
import org.jboss.jca.core.tx.jbossts.XATerminatorImpl;
import org.jboss.jca.core.workmanager.WorkManagerCoordinator;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.tm.JBossXATerminator;
import org.wildfly.clustering.server.GroupMember;
import org.wildfly.clustering.server.dispatcher.CommandDispatcherFactory;

public final class DistributedWorkManagerService
implements Service<NamedDistributedWorkManager> {
    private final NamedDistributedWorkManager value;
    private final InjectedValue<Executor> executorShort = new InjectedValue();
    private final InjectedValue<Executor> executorLong = new InjectedValue();
    private final InjectedValue<JBossContextXATerminator> xaTerminator = new InjectedValue();
    private final InjectedValue<CommandDispatcherFactory> dispatcherFactory = new InjectedValue();

    public DistributedWorkManagerService(NamedDistributedWorkManager value) {
        ConnectorLogger.ROOT_LOGGER.debugf("Building DistributedWorkManager", new Object[0]);
        this.value = value;
    }

    public NamedDistributedWorkManager getValue() throws IllegalStateException {
        return ConnectorServices.notNull(this.value);
    }

    public void start(StartContext context) throws StartException {
        ConnectorLogger.ROOT_LOGGER.debugf("Starting Jakarta Connectors DistributedWorkManager: ", this.value.getName());
        CommandDispatcherTransport transport = new CommandDispatcherTransport((CommandDispatcherFactory<GroupMember>)((CommandDispatcherFactory)this.dispatcherFactory.getValue()), this.value.getName());
        this.value.setTransport((Transport)transport);
        Executor longRunning = (Executor)this.executorLong.getOptionalValue();
        if (longRunning != null) {
            this.value.setLongRunningThreadPool((Executor)((Object)new StatisticsExecutorImpl(longRunning)));
            this.value.setShortRunningThreadPool((Executor)((Object)new StatisticsExecutorImpl((Executor)this.executorShort.getValue())));
        } else {
            this.value.setLongRunningThreadPool((Executor)((Object)new StatisticsExecutorImpl((Executor)this.executorShort.getValue())));
            this.value.setShortRunningThreadPool((Executor)((Object)new StatisticsExecutorImpl((Executor)this.executorShort.getValue())));
        }
        this.value.setXATerminator((XATerminator)new XATerminatorImpl((JBossXATerminator)this.xaTerminator.getValue()));
        this.value.setSecurityIntegration(new ElytronSecurityIntegration());
        try {
            transport.startup();
        }
        catch (Throwable throwable) {
            ConnectorLogger.ROOT_LOGGER.trace("failed to start DWM transport:", throwable);
            throw ConnectorLogger.ROOT_LOGGER.failedToStartDWMTransport(this.value.getName());
        }
        transport.register(new Address(this.value.getId(), this.value.getName(), transport.getId()));
        WorkManagerCoordinator.getInstance().registerWorkManager((WorkManager)this.value);
        ConnectorLogger.ROOT_LOGGER.debugf("Started Jakarta Connectors DistributedWorkManager: ", this.value.getName());
    }

    public void stop(StopContext context) {
        ConnectorLogger.ROOT_LOGGER.debugf("Stopping Jakarta Connectors DistributedWorkManager: ", this.value.getName());
        this.value.prepareShutdown();
        try {
            this.value.getTransport().shutdown();
        }
        catch (Throwable throwable) {
            ConnectorLogger.ROOT_LOGGER.trace("failed to stop DWM transport:", throwable);
        }
        this.value.shutdown();
        WorkManagerCoordinator.getInstance().unregisterWorkManager((WorkManager)this.value);
        ConnectorLogger.ROOT_LOGGER.debugf("Stopped Jakarta Connectors DistributedWorkManager: ", this.value.getName());
    }

    public Injector<Executor> getExecutorShortInjector() {
        return this.executorShort;
    }

    public Injector<Executor> getExecutorLongInjector() {
        return this.executorLong;
    }

    public Injector<JBossContextXATerminator> getXaTerminatorInjector() {
        return this.xaTerminator;
    }

    public Injector<CommandDispatcherFactory> getCommandDispatcherFactoryInjector() {
        return this.dispatcherFactory;
    }
}

