/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.aggregation;

import org.infinispan.objectfilter.impl.aggregation.AvgAccumulator;
import org.infinispan.objectfilter.impl.aggregation.CountAccumulator;
import org.infinispan.objectfilter.impl.aggregation.MaxAccumulator;
import org.infinispan.objectfilter.impl.aggregation.MinAccumulator;
import org.infinispan.objectfilter.impl.aggregation.SumAccumulator;
import org.infinispan.objectfilter.impl.ql.AggregationFunction;

public abstract class FieldAccumulator {
    protected final int inPos;
    protected final int outPos;

    protected FieldAccumulator(int inPos, int outPos) {
        this.inPos = inPos;
        this.outPos = outPos;
    }

    public static void init(Object[] accRow, FieldAccumulator[] accumulators) {
        for (FieldAccumulator acc : accumulators) {
            acc.init(accRow);
        }
    }

    public static void update(Object[] srcRow, Object[] accRow, FieldAccumulator[] accumulators) {
        for (FieldAccumulator acc : accumulators) {
            acc.update(accRow, srcRow[acc.inPos]);
        }
    }

    public static void merge(Object[] srcRow, Object[] accRow, FieldAccumulator[] acc) {
        for (FieldAccumulator a : acc) {
            a.merge(accRow, srcRow[a.inPos]);
        }
    }

    public static void finish(Object[] accRow, FieldAccumulator[] accumulators) {
        for (FieldAccumulator acc : accumulators) {
            acc.finish(accRow);
        }
    }

    public void init(Object[] accRow) {
    }

    public abstract void update(Object[] var1, Object var2);

    protected void merge(Object[] accRow, Object value) {
        this.update(accRow, value);
    }

    protected void finish(Object[] accRow) {
    }

    public static FieldAccumulator makeAccumulator(AggregationFunction aggregationType, int inColumn, int outColumn, Class<?> propertyType) {
        switch (aggregationType) {
            case SUM: {
                return new SumAccumulator(inColumn, outColumn, propertyType);
            }
            case AVG: {
                return new AvgAccumulator(inColumn, outColumn, propertyType);
            }
            case MIN: {
                return new MinAccumulator(inColumn, outColumn, propertyType);
            }
            case MAX: {
                return new MaxAccumulator(inColumn, outColumn, propertyType);
            }
            case COUNT: {
                return new CountAccumulator(inColumn, outColumn);
            }
        }
        throw new IllegalArgumentException("Aggregation " + aggregationType.name() + " is not supported");
    }

    public static Class<?> getOutputType(AggregationFunction aggregationType, Class<?> propertyType) {
        if (aggregationType == AggregationFunction.AVG) {
            return Double.class;
        }
        if (aggregationType == AggregationFunction.COUNT) {
            return Long.class;
        }
        if (aggregationType == AggregationFunction.SUM) {
            return SumAccumulator.getOutputType(propertyType);
        }
        return propertyType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        FieldAccumulator other = (FieldAccumulator)o;
        return this.inPos == other.inPos && this.outPos == other.outPos;
    }

    public int hashCode() {
        return 31 * this.inPos + this.outPos;
    }
}

